/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.sdk;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.lang.Strings;
import com.okta.spring.config.OktaClientProperties;
import com.okta.spring.sdk.cache.SpringCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@Configuration
@Conditional(value={OktaApiTokenCondition.class})
@ConditionalOnClass(value={Client.class})
public class OktaSdkConfig {
    private final OktaClientProperties oktaClientProperties;
    private final CacheManager springCacheManager;

    public OktaSdkConfig(OktaClientProperties oktaClientProperties, @Autowired(required=false) CacheManager springCacheManager) {
        this.oktaClientProperties = oktaClientProperties;
        this.springCacheManager = springCacheManager;
    }

    @Bean
    protected Client oktaSdkClient() {
        ClientBuilder builder = Clients.builder().setCacheManager(this.oktaSdkCacheManager()).setAuthenticationScheme(this.oktaSdkAuthenticationScheme()).setConnectionTimeout(this.oktaClientProperties.getConnectionTimeout()).setClientCredentials(this.oktaSdkClientCredentials()).setOrgUrl(this.oktaClientProperties.getOrgUrl());
        Proxy proxy = this.oktaSdkProxy();
        if (proxy != null) {
            builder.setProxy(this.oktaSdkProxy());
        }
        return builder.build();
    }

    private AuthenticationScheme oktaSdkAuthenticationScheme() {
        return AuthenticationScheme.SSWS;
    }

    private Proxy oktaSdkProxy() {
        OktaClientProperties.ClientProxyInfo proxyInfo = this.oktaClientProperties.getProxy();
        if (proxyInfo == null || !Strings.hasText((String)proxyInfo.getHostname())) {
            return null;
        }
        Proxy proxy = Strings.hasText((String)proxyInfo.getUsername()) || Strings.hasText((String)proxyInfo.getPassword()) ? new Proxy(proxyInfo.getHostname(), proxyInfo.getPort(), proxyInfo.getUsername(), proxyInfo.getPassword()) : new Proxy(proxyInfo.getHostname(), proxyInfo.getPort());
        return proxy;
    }

    private com.okta.sdk.cache.CacheManager oktaSdkCacheManager() {
        return this.springCacheManager != null ? new SpringCacheManager(this.springCacheManager) : null;
    }

    @Bean
    @ConditionalOnMissingBean
    protected ClientCredentials oktaSdkClientCredentials() {
        return new TokenClientCredentials(this.oktaClientProperties.getToken());
    }

    static class OktaApiTokenCondition
    extends SpringBootCondition {
        OktaApiTokenCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Okta Api Token Condition", (Object[])new Object[0]);
            String tokenValue = context.getEnvironment().getProperty("okta.client.token");
            if (StringUtils.hasText((String)tokenValue)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"provided API token"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("provided API token").atAll());
        }
    }
}

