/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth;

import com.okta.spring.oauth.discovery.OidcDiscoveryClient;
import com.okta.spring.oauth.discovery.OidcDiscoveryMetadata;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.client.ResourceAccessException;

public class OktaPropertiesMappingEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String OAUTH_CLIENT_PREFIX = "security.oauth2.client.";
    private static final String OAUTH_RESOURCE_PREFIX = "security.oauth2.resource.";
    private static final String OKTA_OAUTH_PREFIX = "okta.oauth2.";
    private final Logger logger = LoggerFactory.getLogger(OktaPropertiesMappingEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().addLast(this.remappedOktaToStandardOAuthPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.discoveryPropertiesSource((Environment)environment));
        environment.getPropertySources().addLast(this.loadYaml((Resource)new ClassPathResource("com/okta/spring/okta.yml")));
    }

    private PropertySource<?> loadYaml(Resource resource) {
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        if (!resource.exists()) {
            throw new IllegalArgumentException("Resource " + resource + " does not exist");
        }
        try {
            return loader.load("okta-defaults", resource, null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load yaml configuration from " + resource, ex);
        }
    }

    private PropertySource remappedOktaToStandardOAuthPropertySource(Environment environment) {
        HashMap<String, String> tmpValues = new HashMap<String, String>();
        tmpValues.put("security.oauth2.client.clientId", environment.getProperty("okta.oauth2.clientId"));
        tmpValues.put("security.oauth2.client.clientSecret", environment.getProperty("okta.oauth2.clientSecret"));
        tmpValues.put("security.oauth2.resource.serviceId", environment.getProperty("okta.oauth2.audience"));
        return new MapBasedPropertySource("okta-to-oauth2", Collections.unmodifiableMap(tmpValues));
    }

    private PropertySource discoveryPropertiesSource(Environment environment) {
        boolean discoveryDisabled = Boolean.parseBoolean(environment.getProperty("okta.oauth2.discoveryDisabled"));
        if (!discoveryDisabled) {
            String issuerUrl = environment.getProperty("okta.oauth2.issuer");
            try {
                OidcDiscoveryMetadata discoveryMetadata = new OidcDiscoveryClient(issuerUrl).discover();
                HashMap<String, String> tmpValues = new HashMap<String, String>();
                String baseUrl = issuerUrl.substring(0, issuerUrl.lastIndexOf("/oauth2/"));
                tmpValues.put("okta.client.orgUrl", baseUrl);
                tmpValues.put("security.oauth2.client.accessTokenUri", discoveryMetadata.getTokenEndpoint());
                tmpValues.put("security.oauth2.client.userAuthorizationUri", discoveryMetadata.getAuthorizationEndpoint());
                tmpValues.put("security.oauth2.resource.userInfoUri", discoveryMetadata.getUserinfoEndpoint());
                tmpValues.put("security.oauth2.resource.jwk.keySetUri", discoveryMetadata.getJwksUri());
                tmpValues.put("security.oauth2.resource.tokenInfoUri", discoveryMetadata.getIntrospectionEndpoint());
                return new MapBasedPropertySource("discovery-to-oauth2", Collections.unmodifiableMap(tmpValues));
            }
            catch (ResourceAccessException e) {
                this.logger.warn("Failed to discover oauth metadata from url: {}", (Object)issuerUrl, (Object)e);
            }
        }
        return new MapBasedPropertySource("no-discovery", Collections.emptyMap());
    }

    private static class MapBasedPropertySource
    extends EnumerablePropertySource<Map<String, String>> {
        MapBasedPropertySource(String name, Map<String, String> source) {
            super(name, source);
        }

        public Object getProperty(String name) {
            return ((Map)this.getSource()).get(name);
        }

        public String[] getPropertyNames() {
            return ((Map)this.getSource()).keySet().toArray(new String[((Map)this.getSource()).size()]);
        }
    }
}

