/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth;

import com.okta.spring.config.OktaOAuth2Properties;
import com.okta.spring.oauth.ClaimsAuthoritiesExtractor;
import com.okta.spring.oauth.ClaimsPrincipalExtractor;
import com.okta.spring.oauth.ConfigurableAccessTokenConverter;
import com.okta.spring.oauth.OktaUserInfoTokenServices;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.IssuerClaimVerifier;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtClaimsSetVerifier;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

@Configuration
@Import(value={RemoteTokenValidationConfig.class, LocalTokenValidationConfig.class})
public class OktaTokenServicesConfig {

    @Configuration
    @ConditionalOnProperty(name={"okta.oauth2.localTokenValidation"}, matchIfMissing=true)
    public static class LocalTokenValidationConfig {
        private final OktaOAuth2Properties oktaOAuth2Properties;

        public LocalTokenValidationConfig(OktaOAuth2Properties oktaOAuth2Properties) {
            this.oktaOAuth2Properties = oktaOAuth2Properties;
        }

        @Bean
        @ConditionalOnMissingBean
        protected AuthoritiesExtractor authoritiesExtractor() {
            return new ClaimsAuthoritiesExtractor(this.oktaOAuth2Properties.getRolesClaim());
        }

        @Bean
        @ConditionalOnMissingBean
        protected PrincipalExtractor principalExtractor() {
            return new ClaimsPrincipalExtractor(this.oktaOAuth2Properties.getPrincipalClaim());
        }

        @Bean
        public TokenStore tokenStore() {
            return new JwkTokenStore(this.oktaOAuth2Properties.getIssuer() + "/v1/keys", this.accessTokenConverter(), this.jwtClaimsSetVerifier());
        }

        @Bean
        @ConditionalOnMissingBean
        public JwtClaimsSetVerifier jwtClaimsSetVerifier() {
            try {
                return new IssuerClaimVerifier(new URL(this.oktaOAuth2Properties.getIssuer()));
            }
            catch (MalformedURLException e) {
                throw new InvalidPropertyException(JwtClaimsSetVerifier.class, "okta.oauth2.issuer", "Failed to parse issuer URL", (Throwable)e);
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public AccessTokenConverter accessTokenConverter() {
            JwtAccessTokenConverter jwtAccessTokenConverter = new JwtAccessTokenConverter();
            jwtAccessTokenConverter.setAccessTokenConverter((AccessTokenConverter)new ConfigurableAccessTokenConverter(this.oktaOAuth2Properties.getScopeClaim(), this.oktaOAuth2Properties.getRolesClaim()));
            return jwtAccessTokenConverter;
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"okta.oauth2.localTokenValidation"}, havingValue="false")
    public static class RemoteTokenValidationConfig {
        private final OktaOAuth2Properties oktaOAuth2Properties;

        public RemoteTokenValidationConfig(OktaOAuth2Properties oktaOAuth2Properties) {
            this.oktaOAuth2Properties = oktaOAuth2Properties;
        }

        @Bean
        @ConditionalOnMissingBean
        protected AuthoritiesExtractor authoritiesExtractor() {
            return new ClaimsAuthoritiesExtractor(this.oktaOAuth2Properties.getRolesClaim());
        }

        @Bean
        @ConditionalOnMissingBean
        protected PrincipalExtractor principalExtractor() {
            return new ClaimsPrincipalExtractor(this.oktaOAuth2Properties.getPrincipalClaim());
        }

        @Bean
        @Primary
        protected ResourceServerTokenServices resourceServerTokenServices(ResourceServerProperties sso, OAuth2ClientContext oauth2ClientContext, UserInfoRestTemplateFactory restTemplateFactory) {
            OktaUserInfoTokenServices services = new OktaUserInfoTokenServices(sso.getUserInfoUri(), sso.getClientId(), oauth2ClientContext);
            services.setRestTemplate((OAuth2RestOperations)restTemplateFactory.getUserInfoRestTemplate());
            services.setTokenType(sso.getTokenType());
            services.setAuthoritiesExtractor(this.authoritiesExtractor());
            services.setPrincipalExtractor(this.principalExtractor());
            return services;
        }
    }
}

