/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth;

import com.okta.spring.oauth.ScopeSupportedOAuth2Request;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class OktaUserInfoTokenServices
extends UserInfoTokenServices {
    private final OAuth2ClientContext oauth2ClientContext;

    public OktaUserInfoTokenServices(String userInfoEndpointUrl, String clientId, OAuth2ClientContext oauth2ClientContext) {
        super(userInfoEndpointUrl, clientId);
        this.oauth2ClientContext = oauth2ClientContext;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) {
        OAuth2Authentication originalOAuth = super.loadAuthentication(accessToken);
        OAuth2AccessToken existingToken = this.oauth2ClientContext.getAccessToken();
        ScopeSupportedOAuth2Request customOAuth2Request = new ScopeSupportedOAuth2Request(originalOAuth.getOAuth2Request());
        customOAuth2Request.setScope(existingToken.getScope());
        return new OAuth2Authentication((OAuth2Request)customOAuth2Request, originalOAuth.getUserAuthentication());
    }
}

