/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.discovery;

import com.okta.spring.oauth.discovery.OidcDiscoveryMetadata;
import java.net.URI;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcDiscoveryClient {
    private final URI issuerUri;
    private final RestTemplate restTemplate = new RestTemplate();

    public OidcDiscoveryClient(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        try {
            this.issuerUri = UriComponentsBuilder.fromHttpUrl((String)issuer).path("/.well-known/openid-configuration").build().encode().toUri();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid URI for issuer: " + ex.getMessage(), ex);
        }
    }

    public OidcDiscoveryMetadata discover() {
        return (OidcDiscoveryMetadata)this.restTemplate.getForObject(this.issuerUri, OidcDiscoveryMetadata.class);
    }
}

