/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.implicit;

import com.okta.spring.config.OktaOAuth2Properties;
import com.okta.spring.oauth.OktaTokenServicesConfig;
import com.okta.spring.oauth.implicit.Non500ErrorDefaultTokenServices;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;

@ConditionalOnBean(value={ResourceServerConfiguration.class})
@Configuration
@Import(value={OktaTokenServicesConfig.class})
public class ResourceServerConfig {
    private final OktaOAuth2Properties oktaOAuth2Properties;

    public ResourceServerConfig(OktaOAuth2Properties oktaOAuth2Properties) {
        this.oktaOAuth2Properties = oktaOAuth2Properties;
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={ResourceServerTokenServices.class})
    public ResourceServerConfigurerAdapter oktaResourceServerConfigurerAdapter(final ResourceServerTokenServices tokenServices) {
        return new ResourceServerConfigurerAdapter(){

            public void configure(ResourceServerSecurityConfigurer config) {
                config.resourceId(ResourceServerConfig.this.oktaOAuth2Properties.getAudience());
                config.tokenServices(tokenServices);
            }
        };
    }

    @Configuration
    @ConditionalOnProperty(name={"okta.oauth2.localTokenValidation"}, matchIfMissing=true)
    public static class LocalTokenValidationConfig {
        @Bean
        @Primary
        protected ResourceServerTokenServices resourceServerTokenServices(TokenStore tokenStore) {
            Non500ErrorDefaultTokenServices services = new Non500ErrorDefaultTokenServices();
            services.setTokenStore(tokenStore);
            return services;
        }
    }
}

