/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ConfigurableAccessTokenConverter
extends DefaultAccessTokenConverter {
    private static final String SUBJECT_CLAIM = "sub";
    private final String scopeClaim;
    private final String rolesClaim;

    public ConfigurableAccessTokenConverter(String scopeClaim, String rolesClaim) {
        Assert.hasText((String)scopeClaim, (String)"scopeClaim cannot be null or empty.");
        Assert.hasText((String)rolesClaim, (String)"rolesClaim cannot be null or empty.");
        this.scopeClaim = scopeClaim;
        this.rolesClaim = rolesClaim;
    }

    private Map<String, ?> tweakScopeMap(Map<String, ?> map) {
        Object roles;
        Object scope;
        LinkedHashMap tokenMap = new LinkedHashMap(map);
        if (tokenMap.containsKey(this.scopeClaim) && !ObjectUtils.isEmpty(scope = tokenMap.get(this.scopeClaim))) {
            tokenMap.put("scope", scope);
        }
        if (tokenMap.containsKey(this.rolesClaim) && !ObjectUtils.isEmpty(roles = tokenMap.get(this.rolesClaim))) {
            tokenMap.put("authorities", roles);
        }
        if (tokenMap.containsKey(SUBJECT_CLAIM)) {
            Object sub = tokenMap.get(SUBJECT_CLAIM);
            tokenMap.put("user_name", sub);
        }
        return tokenMap;
    }

    public OAuth2AccessToken extractAccessToken(String value, Map<String, ?> map) {
        return super.extractAccessToken(value, this.tweakScopeMap(map));
    }

    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        OAuth2Authentication originalOAuth2Authentication = super.extractAuthentication(this.tweakScopeMap(map));
        Authentication originalUserAuthentication = originalOAuth2Authentication.getUserAuthentication();
        if (originalUserAuthentication != null) {
            UsernamePasswordAuthenticationToken newToken = new UsernamePasswordAuthenticationToken(originalUserAuthentication.getPrincipal(), (Object)"N/A", originalUserAuthentication.getAuthorities());
            newToken.setDetails(Collections.unmodifiableMap(map));
            return new OAuth2Authentication(originalOAuth2Authentication.getOAuth2Request(), (Authentication)newToken);
        }
        return originalOAuth2Authentication;
    }
}

