/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth;

import com.okta.spring.oauth.RemappedPropertySource;
import com.okta.spring.oauth.discovery.DiscoveryPropertySource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class OktaPropertiesMappingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String OAUTH_CLIENT_PREFIX = "security.oauth2.client.";
    private static final String OAUTH_RESOURCE_PREFIX = "security.oauth2.resource.";
    private static final String OKTA_OAUTH_PREFIX = "okta.oauth2.";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().addLast(this.remappedOktaToStandardOAuthPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.loadYaml((Resource)new FileSystemResource(new File(System.getProperty("user.home"), ".okta/okta.yml")), false));
        environment.getPropertySources().addLast(this.loadYaml((Resource)new FileSystemResource(new File(System.getProperty("user.home"), ".okta/okta.yaml")), false));
        environment.getPropertySources().addLast((PropertySource)new DiscoveryPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.oauthToClientPropertiesSource((Environment)environment));
        environment.getPropertySources().addLast(this.loadYaml((Resource)new ClassPathResource("com/okta/spring/okta.yml"), true));
    }

    private PropertySource<?> loadYaml(Resource resource, boolean required) {
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        if (!resource.exists() && required) {
            throw new IllegalArgumentException("Resource " + resource + " does not exist");
        }
        if (resource.exists()) {
            try {
                Method method = ClassUtils.getMethodIfAvailable(YamlPropertySourceLoader.class, (String)"load", (Class[])new Class[]{String.class, Resource.class});
                if (method != null) {
                    List list = (List)method.invoke((Object)loader, resource.getFilename(), resource);
                    return (PropertySource)list.get(0);
                }
                return loader.load(resource.getFilename(), resource, null);
            }
            catch (IOException | IllegalAccessException | InvocationTargetException ex) {
                throw new IllegalStateException("Failed to load yaml configuration from " + resource, ex);
            }
        }
        return new MapPropertySource("Missing " + resource.getFilename(), Collections.emptyMap());
    }

    private PropertySource remappedOktaToStandardOAuthPropertySource(Environment environment) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("security.oauth2.client.clientId", "okta.oauth2.clientId");
        aliasMap.put("security.oauth2.client.clientSecret", "okta.oauth2.clientSecret");
        aliasMap.put("security.oauth2.resource.serviceId", "okta.oauth2.audience");
        return new RemappedPropertySource("okta-to-oauth2", aliasMap, environment);
    }

    private PropertySource oauthToClientPropertiesSource(Environment environment) {
        return new IssuerToOrgUrlPropertySource(environment);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static class IssuerToOrgUrlPropertySource
    extends PropertySource {
        private final Environment environment;

        private IssuerToOrgUrlPropertySource(Environment environment) {
            super("okta-oauth-to-client");
            this.environment = environment;
        }

        public Object getProperty(String name) {
            String issuerUrl;
            if (this.containsProperty(name) && StringUtils.hasText((String)(issuerUrl = this.environment.getProperty("okta.oauth2.issuer")))) {
                return issuerUrl.substring(0, issuerUrl.lastIndexOf("/oauth2/"));
            }
            return null;
        }

        public boolean containsProperty(String name) {
            return "okta.client.org-url".equals(name) || "okta.client.orgUrl".equals(name);
        }
    }
}

