/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.code;

import com.okta.spring.config.OktaOAuth2Properties;
import com.okta.spring.oauth.OAuth2AccessTokenValidationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
class OktaOAuthCodeFlowConfiguration {
    OktaOAuthCodeFlowConfiguration() {
    }

    static class Non500ErrorDefaultTokenServices
    extends DefaultTokenServices {
        private final String audience;

        Non500ErrorDefaultTokenServices(String audience) {
            this.audience = audience;
        }

        public OAuth2Authentication loadAuthentication(String accessTokenValue) {
            try {
                OAuth2Authentication originalOAuth = super.loadAuthentication(accessTokenValue);
                if (!originalOAuth.getOAuth2Request().getResourceIds().contains(this.audience)) {
                    throw new OAuth2AccessTokenValidationException("Invalid token, 'aud' claim does not contain the expected audience of: " + this.audience);
                }
                return originalOAuth;
            }
            catch (InvalidSignatureException e) {
                throw new OAuth2AccessTokenValidationException("Invalid token, invalid signature", e);
            }
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"okta.oauth2.localTokenValidation"}, matchIfMissing=true)
    public static class LocalTokenValidationConfig {
        @Bean
        @Primary
        protected ResourceServerTokenServices resourceServerTokenServices(TokenStore tokenStore, OktaOAuth2Properties properties) {
            Non500ErrorDefaultTokenServices services = new Non500ErrorDefaultTokenServices(properties.getAudience());
            services.setTokenStore(tokenStore);
            return services;
        }
    }
}

