/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.discovery;

import com.okta.spring.oauth.discovery.OidcDiscoveryClient;
import com.okta.spring.oauth.discovery.OidcDiscoveryMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;

public class DiscoveryPropertySource
extends EnumerablePropertySource<String> {
    private static final String OAUTH_CLIENT_PREFIX = "security.oauth2.client.";
    private static final String OAUTH_RESOURCE_PREFIX = "security.oauth2.resource.";
    private static final String OKTA_OAUTH_ISSUER = "okta.oauth2.issuer";
    private static final String OKTA_OAUTH_DISCOVERY_DISABLED = "okta.oauth2.discoveryDisabled";
    private static final String OAUTH_RESOURCE_JWK_SUB_KEY = "security.oauth2.resource.jwk";
    private static final String OAUTH_ACCESS_TOKEN_URI_KEY = "security.oauth2.client.accessTokenUri";
    private static final String OAUTH_ACCESS_USER_AUTH_URI_KEY = "security.oauth2.client.userAuthorizationUri";
    private static final String OAUTH_ACCESS_USER_INFO_URI_KEY = "security.oauth2.resource.userInfoUri";
    private static final String OAUTH_RESOURCE_JWT_KEY_SET_URI_KEY = "security.oauth2.resource.jwk.keySetUri";
    private static final String OAUTH_RESOURCE_JWT_KEY_SET_URI_DASH_KEY = "security.oauth2.resource.jwk.key-set-uri";
    private static final String OAUTH_RESOURCE_TOKEN_INFO_URI = "security.oauth2.resource.tokenInfoUri";
    private static final String[] supportedKeys = new String[]{"security.oauth2.client.accessTokenUri", "security.oauth2.client.userAuthorizationUri", "security.oauth2.resource.userInfoUri", "security.oauth2.resource.jwk", "security.oauth2.resource.jwk.keySetUri", "security.oauth2.resource.jwk.key-set-uri", "security.oauth2.resource.tokenInfoUri"};
    private static final List<String> supportedKeysList = Collections.unmodifiableList(Arrays.asList(supportedKeys));
    private final boolean isEnabled;
    private final Environment environment;
    private Map<String, Object> metadataProperties = null;

    public DiscoveryPropertySource(Environment environment) {
        super("Okta-OIDC-Discovery-Client");
        this.environment = environment;
        this.isEnabled = !Boolean.parseBoolean(environment.getProperty(OKTA_OAUTH_DISCOVERY_DISABLED));
    }

    public Object getProperty(String name) {
        return this.containsProperty(name) && this.isReady() ? this.getDiscoveryMetadata().get(name) : null;
    }

    public boolean containsProperty(String name) {
        return this.isEnabled && supportedKeysList.contains(name);
    }

    public String[] getPropertyNames() {
        return Arrays.copyOf(supportedKeys, supportedKeys.length);
    }

    private boolean isReady() {
        return this.environment.containsProperty(OKTA_OAUTH_ISSUER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getDiscoveryMetadata() {
        if (!this.isEnabled) {
            return Collections.emptyMap();
        }
        if (this.metadataProperties == null) {
            DiscoveryPropertySource discoveryPropertySource = this;
            synchronized (discoveryPropertySource) {
                String issuerUrl = this.environment.getRequiredProperty(OKTA_OAUTH_ISSUER);
                OidcDiscoveryMetadata discoveryMetadata = this.createDiscoveryClient(issuerUrl).discover();
                HashMap<String, Object> tmpValues = new HashMap<String, Object>();
                if (discoveryMetadata != null) {
                    DiscoveryPropertySource.putIfNotNull(tmpValues, OAUTH_ACCESS_TOKEN_URI_KEY, discoveryMetadata.getTokenEndpoint());
                    DiscoveryPropertySource.putIfNotNull(tmpValues, OAUTH_ACCESS_USER_AUTH_URI_KEY, discoveryMetadata.getAuthorizationEndpoint());
                    DiscoveryPropertySource.putIfNotNull(tmpValues, OAUTH_ACCESS_USER_INFO_URI_KEY, discoveryMetadata.getUserinfoEndpoint());
                    DiscoveryPropertySource.putIfNotNull(tmpValues, OAUTH_RESOURCE_JWT_KEY_SET_URI_KEY, discoveryMetadata.getJwksUri());
                    DiscoveryPropertySource.putIfNotNull(tmpValues, OAUTH_RESOURCE_JWT_KEY_SET_URI_DASH_KEY, discoveryMetadata.getJwksUri());
                    DiscoveryPropertySource.putIfNotNull(tmpValues, OAUTH_RESOURCE_TOKEN_INFO_URI, discoveryMetadata.getIntrospectionEndpoint());
                }
                this.metadataProperties = tmpValues;
            }
        }
        return this.metadataProperties;
    }

    private static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    OidcDiscoveryClient createDiscoveryClient(String issuerUrl) {
        return new OidcDiscoveryClient(issuerUrl);
    }
}

