/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.http;

import com.okta.spring.oauth.http.Version;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class UserAgent {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgent.class);
    private static final String INTEGRATION_SHIRO_ID = "okta-shiro";
    private static final String INTEGRATION_SHIRO_CLASS = "com.okta.shiro.realm.ApplicationRealm";
    private static final String INTEGRATION_SPRING_SECURITY_ID = "okta-spring-security";
    private static final String SDK_VERSION_FILE = "/com/okta/sdk/version.properties";
    private static final String OKTA_SDK_STRING = "okta-sdk-java";
    private static final String OKTA_SDK_CLASS = "com.okta.sdk.resource.user.User";
    private static final String OKTA_ZUUL_ID = "okta-zuul";
    private static final String OKTA_ZUUL_CLASS = "com.okta.zuul.filter.AppliedRequestHeaderFilter";
    private static final String OKTA_SDK_SERVLET_ID = "okta-servlet-java";
    private static final String OKTA_SDK_SERVLET_CLASS = "com.okta.sdk.servlet.config.Config";
    private static final String OKTA_SDK_RUNTIME_SPRING_WEBMVC_ID = "okta-spring-webmvc";
    private static final String OKTA_SDK_RUNTIME_SPRING_WEBMVC_CLASS = "com.okta.spring.mvc.AbstractSpringControllerConfig";
    private static final String OKTA_SDK_SPRING_BOOT_STARTER_ID = "okta-spring-boot-starter";
    private static final String OKTA_SDK_SPRING_BOOT_STARTER_CLASS = "com.okta.spring.boot.autoconfigure.OktaAutoConfiguration";
    private static final String INTEGRATION_RUNTIME_SPRING_ID = "spring";
    private static final String INTEGRATION_RUNTIME_SPRING_CLASS = "org.springframework.context.ApplicationContext";
    private static final String RAPID_PROTOTYPING_SPRING_BOOT_ID = "spring-boot";
    private static final String RAPID_PROTOTYPING_SPRING_BOOT_CLASS = "org.springframework.boot.SpringApplication";
    private static final String JAVA_SDK_RUNTIME_STRING = "java";
    private static final String SECURITY_FRAMEWORK_SHIRO_ID = "shiro";
    private static final String SECURITY_FRAMEWORK_SHIRO_CLASS = "org.apache.shiro.SecurityUtils";
    private static final String SECURITY_FRAMEWORK_SPRING_SECURITY_ID = "spring-security";
    private static final String SECURITY_FRAMEWORK_SPRING_SECURITY_CLASS = "org.springframework.security.core.SpringSecurityCoreVersion";
    private static final String WEB_SERVER_TOMCAT_ID = "tomcat";
    private static final String WEB_SERVER_TOMCAT_BOOTSTRAP_CLASS = "org.apache.catalina.startup.Bootstrap";
    private static final String WEB_SERVER_TOMCAT_EMBEDDED_CLASS = "org.apache.catalina.startup.Tomcat";
    private static final String WEB_SERVER_JETTY_ID = "jetty";
    private static final String WEB_SERVER_JETTY_CLASS = "org.eclipse.jetty.servlet.listener.ELContextCleaner";
    private static final String WEB_SERVER_JBOSS_ID = "jboss";
    private static final String WEB_SERVER_JBOSS_CLASS = "org.jboss.as.security.plugins.AuthenticationCacheEvictionListener";
    private static final String WEB_SERVER_WEBSPHERE_ID = "websphere";
    private static final String WEB_SERVER_WEBSPHERE_CLASS = "com.ibm.websphere.product.VersionInfo";
    private static final String WEB_SERVER_GLASSFISH_ID = "glassfish";
    private static final String WEB_SERVER_GLASSFISH_CLASS = "com.sun.enterprise.glassfish.bootstrap.GlassFishMain";
    private static final String WEB_SERVER_WEBLOGIC_ID = "weblogic";
    private static final String WEB_SERVER_WEBLOGIC_CLASS = "weblogic.version";
    private static final String WEB_SERVER_WILDFLY_ID = "wildfly";
    private static final String WEB_SERVER_WILDFLY_CLASS = "org.jboss.as.security.ModuleName";
    private static final String VERSION_SEPARATOR = "/";
    private static final String ENTRY_SEPARATOR = " ";
    private static final String USER_AGENT = UserAgent.createUserAgentString();

    private UserAgent() {
    }

    public static String getUserAgentString() {
        return USER_AGENT;
    }

    private static String createUserAgentString() {
        String userAgent = UserAgent.getOktaSpringString() + UserAgent.getOktaShiroString() + UserAgent.getOktaSDKComponentsString() + UserAgent.getOktaSdkString() + UserAgent.getSecurityFrameworkString() + UserAgent.getIntegrationRuntimeString() + UserAgent.getSpringBootString() + UserAgent.getWebServerString() + UserAgent.getJavaSDKRuntimeString() + UserAgent.getOSString();
        return userAgent.trim();
    }

    private static String getOktaShiroString() {
        String integrationString = UserAgent.getFullEntryStringUsingPomProperties(INTEGRATION_SHIRO_CLASS, INTEGRATION_SHIRO_ID);
        if (StringUtils.hasText((String)integrationString)) {
            return integrationString;
        }
        return "";
    }

    private static String getOktaSpringString() {
        return "okta-spring-security/" + Version.getClientVersion() + ENTRY_SEPARATOR;
    }

    private static String getOktaSdkString() {
        if (ClassUtils.isPresent((String)OKTA_SDK_CLASS, null)) {
            return "okta-sdk-java/" + Version.getClientVersion(SDK_VERSION_FILE) + ENTRY_SEPARATOR;
        }
        return "";
    }

    private static String getIntegrationRuntimeString() {
        String integrationRuntimeString = UserAgent.getFullEntryStringUsingManifest(INTEGRATION_RUNTIME_SPRING_CLASS, INTEGRATION_RUNTIME_SPRING_ID);
        if (StringUtils.hasText((String)integrationRuntimeString)) {
            return integrationRuntimeString;
        }
        return "";
    }

    private static String getJavaSDKRuntimeString() {
        return "java/" + System.getProperty("java.version") + ENTRY_SEPARATOR;
    }

    private static String getOSString() {
        return System.getProperty("os.name") + VERSION_SEPARATOR + System.getProperty("os.version") + ENTRY_SEPARATOR;
    }

    private static String getSpringBootString() {
        String springBootStarter = UserAgent.getFullEntryStringUsingManifest(RAPID_PROTOTYPING_SPRING_BOOT_CLASS, RAPID_PROTOTYPING_SPRING_BOOT_ID);
        if (StringUtils.hasText((String)springBootStarter)) {
            return springBootStarter;
        }
        return "";
    }

    private static String getSecurityFrameworkString() {
        String securityFrameworkString = UserAgent.getFullEntryStringUsingManifest(SECURITY_FRAMEWORK_SHIRO_CLASS, SECURITY_FRAMEWORK_SHIRO_ID);
        if (StringUtils.hasText((String)securityFrameworkString)) {
            return securityFrameworkString;
        }
        securityFrameworkString = UserAgent.getFullEntryStringUsingManifest(SECURITY_FRAMEWORK_SPRING_SECURITY_CLASS, SECURITY_FRAMEWORK_SPRING_SECURITY_ID);
        if (StringUtils.hasText((String)securityFrameworkString)) {
            return securityFrameworkString;
        }
        return "";
    }

    private static String getOktaSDKComponentsString() {
        StringBuilder sb = new StringBuilder();
        UserAgent.append(sb, UserAgent.getFullEntryStringUsingSDKVersion(OKTA_ZUUL_CLASS, OKTA_ZUUL_ID));
        UserAgent.append(sb, UserAgent.getFullEntryStringUsingSDKVersion(OKTA_SDK_SERVLET_CLASS, OKTA_SDK_SERVLET_ID));
        UserAgent.append(sb, UserAgent.getFullEntryStringUsingSDKVersion(OKTA_SDK_RUNTIME_SPRING_WEBMVC_CLASS, OKTA_SDK_RUNTIME_SPRING_WEBMVC_ID));
        UserAgent.append(sb, UserAgent.getFullEntryStringUsingSDKVersion(OKTA_SDK_SPRING_BOOT_STARTER_CLASS, OKTA_SDK_SPRING_BOOT_STARTER_ID));
        return sb.toString();
    }

    private static void append(StringBuilder sb, String value) {
        if (StringUtils.hasText((String)value)) {
            sb.append(value);
        }
    }

    private static String getWebServerString() {
        String webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_GLASSFISH_CLASS, WEB_SERVER_GLASSFISH_ID);
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_TOMCAT_BOOTSTRAP_CLASS, WEB_SERVER_TOMCAT_ID);
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_TOMCAT_EMBEDDED_CLASS, WEB_SERVER_TOMCAT_ID);
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_JETTY_CLASS, WEB_SERVER_JETTY_ID);
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getWildFlyEntryString();
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_JBOSS_CLASS, WEB_SERVER_JBOSS_ID);
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getWebSphereEntryString();
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getWebLogicEntryString();
        if (StringUtils.hasText((String)webServerString)) {
            return webServerString;
        }
        return "";
    }

    private static String getFullEntryStringUsingPomProperties(String fqcn, String entryId) {
        if (ClassUtils.isPresent((String)fqcn, null)) {
            return entryId + VERSION_SEPARATOR + UserAgent.getVersionInfoFromPomProperties(fqcn) + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getFullEntryStringUsingManifest(String fqcn, String entryId) {
        if (ClassUtils.isPresent((String)fqcn, null)) {
            return entryId + VERSION_SEPARATOR + UserAgent.getVersionInfoInManifest(fqcn) + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getFullEntryStringUsingSDKVersion(String fqcn, String entryId) {
        if (ClassUtils.isPresent((String)fqcn, null)) {
            return entryId + VERSION_SEPARATOR + UserAgent.getVersionInfoInManifest(fqcn) + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getWebSphereEntryString() {
        if (ClassUtils.isPresent((String)WEB_SERVER_WEBSPHERE_CLASS, null)) {
            return "websphere/" + UserAgent.getWebSphereVersion() + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getWebLogicEntryString() {
        if (ClassUtils.isPresent((String)WEB_SERVER_WEBLOGIC_CLASS, null)) {
            return "weblogic/" + UserAgent.getWebLogicVersion() + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getWildFlyEntryString() {
        try {
            Package wildFlyPkg;
            if (ClassUtils.isPresent((String)WEB_SERVER_WILDFLY_CLASS, null) && (wildFlyPkg = ClassUtils.forName((String)WEB_SERVER_WILDFLY_CLASS, null).getPackage()) != null && StringUtils.hasText((String)wildFlyPkg.getImplementationTitle()) && wildFlyPkg.getImplementationTitle().contains("WildFly")) {
                return "wildfly/" + wildFlyPkg.getImplementationVersion() + ENTRY_SEPARATOR;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getVersionInfoFromPomProperties(String fqcn) {
        String version;
        block34: {
            version = "unknown";
            try {
                Enumeration<JarEntry> enumeration;
                Class clazz = ClassUtils.forName((String)fqcn, null);
                String className = clazz.getSimpleName() + ".class";
                String classPath = clazz.getResource(className).toString();
                String jarPath = null;
                if (classPath.startsWith("jar:file:")) {
                    jarPath = classPath.subSequence(9, classPath.lastIndexOf("!")).toString();
                } else if (classPath.startsWith("vfs:")) {
                    jarPath = classPath.subSequence(4, classPath.lastIndexOf(".jar") + 4).toString();
                }
                if (jarPath == null) {
                    return version;
                }
                try (JarFile jarFile = new JarFile(jarPath);){
                    enumeration = jarFile.entries();
                }
                String pomPropertiesPath = null;
                while (enumeration.hasMoreElements()) {
                    JarEntry entry = enumeration.nextElement();
                    if (!entry.getName().endsWith("pom.properties")) continue;
                    pomPropertiesPath = entry.getName();
                    break;
                }
                if (pomPropertiesPath == null) break block34;
                var9_9 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(VERSION_SEPARATOR + pomPropertiesPath), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("version=")) continue;
                        version = line.split("=")[1];
                        break;
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = throwable;
                    throw throwable;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return version;
    }

    private static String getVersionInfoInManifest(String fqcn) {
        String version = null;
        try {
            Package thePackage = ClassUtils.forName((String)fqcn, null).getPackage();
            version = thePackage.getSpecificationVersion();
            if (!StringUtils.hasText((String)version)) {
                version = thePackage.getImplementationVersion();
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Failed resolve version for class '{}'", (Object)fqcn, (Object)e);
        }
        if (!StringUtils.hasText((String)version)) {
            version = "null";
        }
        return version;
    }

    private static String getWebSphereVersion() {
        try {
            Class<?> versionClass = Class.forName(WEB_SERVER_WEBSPHERE_CLASS);
            Object versionInfo = versionClass.newInstance();
            Method method = versionClass.getDeclaredMethod("runReport", String.class, PrintWriter.class);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            method.invoke(versionInfo, "", printWriter);
            String version = stringWriter.toString();
            version = version.substring(version.indexOf("Installed Product"));
            version = version.substring(version.indexOf("Version"));
            version = version.substring(version.indexOf(ENTRY_SEPARATOR), version.indexOf("\n")).trim();
            return version;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            return "null";
        }
    }

    private static String getWebLogicVersion() {
        try {
            Class<?> versionClass = Class.forName(WEB_SERVER_WEBLOGIC_CLASS);
            Object version = versionClass.newInstance();
            Method method = versionClass.getDeclaredMethod("getReleaseBuildVersion", new Class[0]);
            return (String)method.invoke(version, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            return "null";
        }
    }
}

