/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

class Version {
    private static final String VERSION_FILE = "/com/okta/spring/version.properties";
    private static final String CLIENT_VERSION = Version.lookupClientVersion("/com/okta/spring/version.properties");

    private Version() {
    }

    public static String getClientVersion() {
        return CLIENT_VERSION;
    }

    public static String getClientVersion(String versionFile) {
        return Version.lookupClientVersion(versionFile);
    }

    private static String lookupClientVersion(String versionFile) {
        Class<Version> clazz = Version.class;
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = clazz.getResourceAsStream(versionFile);
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null && (line.startsWith("#") || line.isEmpty())) {
            }
            String string = line;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to obtain version from [" + versionFile + "].", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception while trying to close file [" + versionFile + "].", e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception while trying to close file [" + versionFile + "].", e);
                }
            }
        }
    }
}

