/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.code;

import com.okta.spring.oauth.OAuth2AccessTokenValidationException;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;

public class CodeFlowAudienceValidatingTokenServices
extends DefaultTokenServices {
    private final String audience;

    public CodeFlowAudienceValidatingTokenServices(String audience) {
        this.audience = audience;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) {
        try {
            OAuth2Authentication originalOAuth = super.loadAuthentication(accessTokenValue);
            if (!originalOAuth.getOAuth2Request().getResourceIds().contains(this.audience)) {
                throw new OAuth2AccessTokenValidationException("Invalid token, 'aud' claim does not contain the expected audience of: " + this.audience);
            }
            return originalOAuth;
        }
        catch (InvalidSignatureException e) {
            throw new OAuth2AccessTokenValidationException("Invalid token, invalid signature", e);
        }
    }
}

