/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.code;

import com.okta.spring.config.OktaOAuth2Properties;
import com.okta.spring.oauth.code.CodeFlowAudienceValidatingTokenServices;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
class OktaOAuthCodeFlowConfiguration {
    OktaOAuthCodeFlowConfiguration() {
    }

    @Configuration
    @ConditionalOnProperty(name={"okta.oauth2.localTokenValidation"}, matchIfMissing=true)
    public static class LocalTokenValidationConfig {
        @Bean
        @Primary
        protected ResourceServerTokenServices resourceServerTokenServices(TokenStore tokenStore, OktaOAuth2Properties properties) {
            CodeFlowAudienceValidatingTokenServices services = new CodeFlowAudienceValidatingTokenServices(properties.getAudience());
            services.setTokenStore(tokenStore);
            return services;
        }
    }
}

