/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.discovery;

import com.okta.spring.oauth.discovery.OidcDiscoveryMetadata;
import com.okta.spring.oauth.http.UserAgent;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcDiscoveryClient {
    private final URI issuerUri;
    private final RestTemplate restTemplate = OidcDiscoveryClient.restTemplate();

    public OidcDiscoveryClient(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        try {
            this.issuerUri = UriComponentsBuilder.fromHttpUrl((String)issuer).path("/.well-known/openid-configuration").build().encode().toUri();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid URI for issuer: " + ex.getMessage(), ex);
        }
    }

    public OidcDiscoveryMetadata discover() {
        return (OidcDiscoveryMetadata)this.restTemplate.getForObject(this.issuerUri, OidcDiscoveryMetadata.class);
    }

    private static RestTemplate restTemplate() {
        RestTemplate template = new RestTemplate();
        template.getInterceptors().add(new UserAgentInterceptor());
        return template;
    }

    private static class UserAgentInterceptor
    implements ClientHttpRequestInterceptor {
        private UserAgentInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().add("User-Agent", UserAgent.getUserAgentString());
            return execution.execute(request, body);
        }
    }
}

