/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.env;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;

public class RemappedPropertySource
extends EnumerablePropertySource<String> {
    private final Map<String, String> aliasMap = new HashMap<String, String>();
    private final Environment environment;

    public RemappedPropertySource(String name, Map<String, String> aliasMap, Environment environment) {
        super(name);
        this.aliasMap.putAll(aliasMap);
        this.environment = environment;
    }

    public Object getProperty(String name) {
        String remappedKey = this.aliasMap.get(name);
        if (remappedKey != null) {
            return this.environment.getProperty(remappedKey);
        }
        return null;
    }

    public String[] getPropertyNames() {
        return this.aliasMap.keySet().toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemappedPropertySource that = (RemappedPropertySource)((Object)o);
        return Objects.equals(this.aliasMap, that.aliasMap) && Objects.equals(this.environment, that.environment);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aliasMap, this.environment);
    }
}

