/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.oauth.implicit;

import com.okta.spring.oauth.OAuth2AccessTokenValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;

public class ImplicitAudienceValidatingTokenServices
extends DefaultTokenServices {
    private final Logger logger = LoggerFactory.getLogger(ImplicitAudienceValidatingTokenServices.class);
    private final String audience;

    public ImplicitAudienceValidatingTokenServices(String audience) {
        this.audience = audience;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) {
        try {
            OAuth2Authentication originalOAuth = super.loadAuthentication(accessTokenValue);
            if (!originalOAuth.getOAuth2Request().getResourceIds().contains(this.audience)) {
                throw new OAuth2AccessTokenValidationException("Invalid token, 'aud' claim does not contain the expected audience of: " + this.audience);
            }
            return originalOAuth;
        }
        catch (InvalidSignatureException e) {
            this.logger.debug("Invalid Token Signature: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

