/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.OktaJwtAuthenticationConverter;
import com.okta.spring.boot.oauth.OktaOAuth2UserService;
import com.okta.spring.boot.oauth.OktaOidcUserService;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import com.okta.spring.boot.oauth.http.UserAgentRequestInterceptor;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

final class OktaOAuth2Configurer
extends AbstractHttpConfigurer<OktaOAuth2Configurer, HttpSecurity> {
    OktaOAuth2Configurer() {
    }

    public void init(HttpSecurity http) throws Exception {
        ApplicationContext context = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        if (!context.getBeansOfType(OktaOAuth2Properties.class).isEmpty()) {
            OktaOAuth2Properties oktaOAuth2Properties = (OktaOAuth2Properties)context.getBean(OktaOAuth2Properties.class);
            if (!context.getBeansOfType(OAuth2ClientProperties.class).isEmpty()) {
                this.configureLogin(http, oktaOAuth2Properties);
            }
            if (!context.getBeansOfType(OAuth2ResourceServerProperties.class).isEmpty()) {
                this.configureResourceServer(http, oktaOAuth2Properties);
            }
        }
    }

    private void configureLogin(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties) throws Exception {
        http.oauth2Login().userInfoEndpoint().userService((OAuth2UserService)new OktaOAuth2UserService(oktaOAuth2Properties.getGroupsClaim())).oidcUserService((OAuth2UserService)new OktaOidcUserService(oktaOAuth2Properties.getGroupsClaim())).and().tokenEndpoint().accessTokenResponseClient(this.accessTokenResponseClient());
        if (oktaOAuth2Properties.getRedirectUri() != null) {
            http.oauth2Login().redirectionEndpoint().baseUri(oktaOAuth2Properties.getRedirectUri());
        }
    }

    private void configureResourceServer(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties) throws Exception {
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)new OktaJwtAuthenticationConverter(oktaOAuth2Properties.getGroupsClaim()));
    }

    private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()));
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        restTemplate.getInterceptors().add(new UserAgentRequestInterceptor());
        DefaultAuthorizationCodeTokenResponseClient accessTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        accessTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return accessTokenResponseClient;
    }
}

