/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.OktaJwtAuthenticationConverter;
import com.okta.spring.boot.oauth.ReactiveOktaOAuth2ResourceServerAutoConfig;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverterAdapter;

@Configuration
@AutoConfigureAfter(value={ReactiveOktaOAuth2ResourceServerAutoConfig.class})
@EnableConfigurationProperties(value={OktaOAuth2Properties.class, OAuth2ResourceServerProperties.class})
@ConditionalOnClass(value={EnableWebFluxSecurity.class, BearerTokenAuthenticationToken.class, ReactiveJwtDecoder.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class ReactiveOktaOAuth2ResourceServerHttpServerAutoConfig {
    ReactiveOktaOAuth2ResourceServerHttpServerAutoConfig() {
    }

    @Bean
    BeanPostProcessor oktaOAuth2ResourceServerBeanPostProcessor(OktaOAuth2Properties oktaOAuth2Properties) {
        return new OktaOAuth2ResourceServerBeanPostProcessor(oktaOAuth2Properties);
    }

    static class OktaOAuth2ResourceServerBeanPostProcessor
    implements BeanPostProcessor {
        private final OktaOAuth2Properties oktaOAuth2Properties;

        OktaOAuth2ResourceServerBeanPostProcessor(OktaOAuth2Properties oktaOAuth2Properties) {
            this.oktaOAuth2Properties = oktaOAuth2Properties;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof ServerHttpSecurity) {
                ServerHttpSecurity http = (ServerHttpSecurity)bean;
                http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)new ReactiveJwtAuthenticationConverterAdapter((JwtAuthenticationConverter)new OktaJwtAuthenticationConverter(this.oktaOAuth2Properties.getGroupsClaim())));
            }
            return bean;
        }
    }
}

