/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.OktaOAuth2UserService;
import com.okta.spring.boot.oauth.UserUtil;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

final class OktaOidcUserService
extends OidcUserService {
    private final String groupClaim;

    OktaOidcUserService(String groupClaim) {
        this.groupClaim = groupClaim;
        this.setOauth2UserService((OAuth2UserService)new OktaOAuth2UserService(groupClaim));
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user = super.loadUser(userRequest);
        return UserUtil.decorateUser(user, userRequest, this.groupClaim);
    }
}

