/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    private static final OAuth2Error INVALID_AUDIENCE = new OAuth2Error("invalid_request", "This aud claim is not equal to the configured audience", "https://tools.ietf.org/html/rfc6750#section-3.1");

    private TokenUtil() {
    }

    static Collection<? extends GrantedAuthority> tokenScopesToAuthorities(OAuth2AccessToken accessToken) {
        if (accessToken == null || accessToken.getScopes() == null) {
            return Collections.emptySet();
        }
        return accessToken.getScopes().stream().map(scope -> "SCOPE_" + scope).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    static Collection<? extends GrantedAuthority> tokenClaimsToAuthorities(Map<String, Object> attributes, String claimKey) {
        if (!CollectionUtils.isEmpty(attributes) && StringUtils.hasText((String)claimKey)) {
            Object rawRoleClaim = attributes.get(claimKey);
            if (rawRoleClaim instanceof Collection) {
                return ((Collection)rawRoleClaim).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
            }
            if (rawRoleClaim != null) {
                log.debug("Could not extract authorities from claim '{}', value was not a collection", (Object)claimKey);
            }
        }
        return Collections.emptySet();
    }

    static OAuth2TokenValidator<Jwt> jwtValidator(String issuer, String audience) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(issuer));
        validators.add(token -> {
            HashSet<String> expectedAudience = new HashSet<String>();
            expectedAudience.add(audience);
            return !Collections.disjoint(token.getAudience(), expectedAudience) ? OAuth2TokenValidatorResult.success() : OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{INVALID_AUDIENCE});
        });
        return new DelegatingOAuth2TokenValidator(validators);
    }
}

