/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth.config;

import com.okta.commons.configcheck.ConfigurationValidator;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@ConfigurationProperties(value="okta.oauth2")
public final class OktaOAuth2Properties
implements Validator {
    private final OAuth2ClientProperties clientProperties;
    private String redirectUri;
    private String clientId;
    private String clientSecret;
    private String issuer;
    private Set<String> scopes;
    private String audience = "api://default";
    private String groupsClaim = "groups";
    private String postLogoutRedirectUri;
    private Proxy proxy;

    private OktaOAuth2Properties() {
        this(null);
    }

    @Autowired
    public OktaOAuth2Properties(@Autowired(required=false) OAuth2ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public String getClientId() {
        return this.getRegistration().map(OAuth2ClientProperties.Registration::getClientId).orElse(this.clientId);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.getRegistration().map(OAuth2ClientProperties.Registration::getClientSecret).orElse(this.clientSecret);
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    public Set<String> getScopes() {
        return this.getRegistration().map(OAuth2ClientProperties.Registration::getScope).orElse(this.scopes);
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    private Optional<OAuth2ClientProperties.Registration> getRegistration() {
        return Optional.ofNullable(this.clientProperties != null ? (OAuth2ClientProperties.Registration)this.clientProperties.getRegistration().get("okta") : null);
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean supports(Class<?> clazz) {
        return OktaOAuth2Properties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        OktaOAuth2Properties properties = (OktaOAuth2Properties)target;
        if (properties.getClientId() != null) {
            ConfigurationValidator.validateClientId((String)properties.getClientId()).ifInvalid(res -> errors.rejectValue("clientId", res.getMessage()));
        }
        if (properties.getClientSecret() != null) {
            ConfigurationValidator.validateClientSecret((String)properties.getClientSecret()).ifInvalid(res -> errors.rejectValue("clientSecret", res.getMessage()));
        }
        if (properties.getIssuer() != null) {
            ConfigurationValidator.validateIssuer((String)properties.getIssuer()).ifInvalid(res -> errors.rejectValue("issuer", res.getMessage()));
        }
    }

    public static class Proxy {
        private String host;
        private int port;
        private String username;
        private String password;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

