/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.commons.lang.Strings;
import com.okta.spring.boot.oauth.ConditionalOnOktaResourceServerProperties;
import com.okta.spring.boot.oauth.OktaJwtAuthenticationConverter;
import com.okta.spring.boot.oauth.OktaOpaqueTokenIntrospectConditional;
import com.okta.spring.boot.oauth.TokenUtil;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import com.okta.spring.boot.oauth.http.UserAgentRequestInterceptor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureBefore(value={OAuth2ResourceServerAutoConfiguration.class})
@ConditionalOnClass(value={JwtAuthenticationToken.class})
@ConditionalOnOktaResourceServerProperties
@EnableConfigurationProperties(value={OktaOAuth2Properties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class OktaOAuth2ResourceServerAutoConfig {
    OktaOAuth2ResourceServerAutoConfig() {
    }

    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter(OktaOAuth2Properties oktaOAuth2Properties) {
        OktaJwtAuthenticationConverter converter = new OktaJwtAuthenticationConverter(oktaOAuth2Properties.getGroupsClaim());
        converter.setJwtGrantedAuthoritiesConverter((Converter)new JwtGrantedAuthoritiesConverter());
        return converter;
    }

    @Bean
    @ConditionalOnMissingBean
    JwtDecoder jwtDecoder(OAuth2ResourceServerProperties oAuth2ResourceServerProperties, OktaOAuth2Properties oktaOAuth2Properties) {
        NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder builder = NimbusJwtDecoder.withJwkSetUri((String)oAuth2ResourceServerProperties.getJwt().getJwkSetUri());
        builder.restOperations((RestOperations)OktaOAuth2ResourceServerAutoConfig.restTemplate(oktaOAuth2Properties));
        NimbusJwtDecoder decoder = builder.build();
        decoder.setJwtValidator(TokenUtil.jwtValidator(oAuth2ResourceServerProperties.getJwt().getIssuerUri(), oktaOAuth2Properties.getAudience()));
        return decoder;
    }

    static RestTemplate restTemplate(OktaOAuth2Properties oktaOAuth2Properties) {
        Proxy proxy;
        OktaOAuth2Properties.Proxy proxyProperties = oktaOAuth2Properties.getProxy();
        Optional<BasicAuthenticationInterceptor> basicAuthenticationInterceptor = Optional.empty();
        if (proxyProperties != null && Strings.hasText((String)proxyProperties.getHost()) && proxyProperties.getPort() > 0) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyProperties.getHost(), proxyProperties.getPort()));
            if (Strings.hasText((String)proxyProperties.getUsername()) && Strings.hasText((String)proxyProperties.getPassword())) {
                basicAuthenticationInterceptor = Optional.of(new BasicAuthenticationInterceptor(proxyProperties.getUsername(), proxyProperties.getPassword()));
            }
        } else {
            proxy = Proxy.NO_PROXY;
        }
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter(), new StringHttpMessageConverter()));
        restTemplate.getInterceptors().add(new UserAgentRequestInterceptor());
        basicAuthenticationInterceptor.ifPresent(restTemplate.getInterceptors()::add);
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setProxy(proxy);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }

    @Bean
    @Conditional(value={OktaOpaqueTokenIntrospectConditional.class})
    OpaqueTokenIntrospector opaqueTokenIntrospector(OktaOAuth2Properties oktaOAuth2Properties, OAuth2ResourceServerProperties oAuth2ResourceServerProperties) {
        RestTemplate restTemplate = OktaOAuth2ResourceServerAutoConfig.restTemplate(oktaOAuth2Properties);
        restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(oAuth2ResourceServerProperties.getOpaquetoken().getClientId(), oAuth2ResourceServerProperties.getOpaquetoken().getClientSecret()));
        NimbusOpaqueTokenIntrospector delegate = new NimbusOpaqueTokenIntrospector(oAuth2ResourceServerProperties.getOpaquetoken().getIntrospectionUri(), (RestOperations)restTemplate);
        return arg_0 -> OktaOAuth2ResourceServerAutoConfig.lambda$opaqueTokenIntrospector$0((OpaqueTokenIntrospector)delegate, oktaOAuth2Properties, arg_0);
    }

    private static /* synthetic */ OAuth2AuthenticatedPrincipal lambda$opaqueTokenIntrospector$0(OpaqueTokenIntrospector delegate, OktaOAuth2Properties oktaOAuth2Properties, String token) {
        OAuth2AuthenticatedPrincipal principal = delegate.introspect(token);
        Collection<? extends GrantedAuthority> mappedAuthorities = Collections.unmodifiableCollection(TokenUtil.opaqueTokenClaimsToAuthorities(principal.getAttributes(), oktaOAuth2Properties.getGroupsClaim(), principal.getAuthorities()));
        return new DefaultOAuth2AuthenticatedPrincipal(principal.getName(), principal.getAttributes(), mappedAuthorities);
    }
}

