/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.commons.lang.Strings;
import com.okta.spring.boot.oauth.OktaJwtAuthenticationConverter;
import com.okta.spring.boot.oauth.OktaOAuth2ResourceServerAutoConfig;
import com.okta.spring.boot.oauth.TokenUtil;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

final class OktaOAuth2Configurer
extends AbstractHttpConfigurer<OktaOAuth2Configurer, HttpSecurity> {
    private static final Logger log = LoggerFactory.getLogger(OktaOAuth2Configurer.class);

    OktaOAuth2Configurer() {
    }

    public void init(HttpSecurity http) throws Exception {
        ApplicationContext context = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        if (!context.getBeansOfType(OktaOAuth2Properties.class).isEmpty()) {
            OAuth2ClientProperties.Registration propertiesRegistration;
            OAuth2ClientProperties.Provider propertiesProvider;
            OktaOAuth2Properties oktaOAuth2Properties = (OktaOAuth2Properties)context.getBean(OktaOAuth2Properties.class);
            if (!(context.getBeansOfType(OAuth2ClientProperties.class).isEmpty() || (propertiesProvider = (OAuth2ClientProperties.Provider)((OAuth2ClientProperties)context.getBean(OAuth2ClientProperties.class)).getProvider().get("okta")) == null || (propertiesRegistration = (OAuth2ClientProperties.Registration)((OAuth2ClientProperties)context.getBean(OAuth2ClientProperties.class)).getRegistration().get("okta")) == null || Strings.isEmpty((Object)propertiesProvider.getIssuerUri()) || Strings.isEmpty((Object)propertiesRegistration.getClientId()))) {
                this.configureLogin(http, oktaOAuth2Properties, (Environment)context.getBean(Environment.class));
                if (!context.getBeansOfType(OidcClientInitiatedLogoutSuccessHandler.class).isEmpty()) {
                    http.logout().logoutSuccessHandler((LogoutSuccessHandler)context.getBean(OidcClientInitiatedLogoutSuccessHandler.class));
                }
                if (TokenUtil.isRootOrgIssuer(propertiesProvider.getIssuerUri())) {
                    log.debug("Opaque Token validation/introspection will be configured.");
                    this.configureResourceServerForOpaqueTokenValidation(http, oktaOAuth2Properties);
                    return;
                }
                OAuth2ResourceServerConfigurer oAuth2ResourceServerConfigurer = (OAuth2ResourceServerConfigurer)http.getConfigurer(OAuth2ResourceServerConfigurer.class);
                if (this.getJwtConfigurer(oAuth2ResourceServerConfigurer).isPresent()) {
                    log.debug("JWT configurer is set in OAuth resource server configuration. JWT validation will be configured.");
                    this.configureResourceServerForJwtValidation(http, oktaOAuth2Properties);
                } else if (this.getOpaqueTokenConfigurer(oAuth2ResourceServerConfigurer).isPresent()) {
                    log.debug("Opaque Token configurer is set in OAuth resource server configuration. Opaque Token validation/introspection will be configured.");
                    this.configureResourceServerForOpaqueTokenValidation(http, oktaOAuth2Properties);
                } else {
                    log.debug("OAuth2ResourceServerConfigurer bean not configured, Resource Server support will not be enabled.");
                }
            } else {
                log.debug("OAuth/OIDC Login not configured due to missing issuer, client-id, or client-secret property");
            }
        }
    }

    private Optional<OAuth2ResourceServerConfigurer.JwtConfigurer> getJwtConfigurer(OAuth2ResourceServerConfigurer<?> oAuth2ResourceServerConfigurer) throws IllegalAccessException {
        if (oAuth2ResourceServerConfigurer != null) {
            return this.getFieldValue(oAuth2ResourceServerConfigurer, "jwtConfigurer");
        }
        return Optional.empty();
    }

    private Optional<OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer> getOpaqueTokenConfigurer(OAuth2ResourceServerConfigurer<?> oAuth2ResourceServerConfigurer) throws IllegalAccessException {
        if (oAuth2ResourceServerConfigurer != null) {
            return this.getFieldValue(oAuth2ResourceServerConfigurer, "opaqueTokenConfigurer");
        }
        return Optional.empty();
    }

    private <T> Optional<T> getFieldValue(Object source, String fieldName) throws IllegalAccessException {
        Field field = AccessController.doPrivileged(() -> {
            Field result = null;
            try {
                result = OAuth2ResourceServerConfigurer.class.getDeclaredField(fieldName);
                result.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                log.warn("Could not get field '" + fieldName + "' of {} via reflection", (Object)OAuth2ResourceServerConfigurer.class.getName(), (Object)e);
            }
            return result;
        });
        if (field == null) {
            String errMsg = "Expected field '" + fieldName + "' was not found in OAuth resource server configuration. Version incompatibility with Spring Security detected.Check https://github.com/okta/okta-spring-boot for project updates.";
            throw new RuntimeException(errMsg);
        }
        return Optional.ofNullable(field.get(source));
    }

    private void unsetJwtConfigurer(OAuth2ResourceServerConfigurer oAuth2ResourceServerConfigurer) {
        AccessController.doPrivileged(() -> {
            Field result = null;
            try {
                result = OAuth2ResourceServerConfigurer.class.getDeclaredField("jwtConfigurer");
                result.setAccessible(true);
                result.set(oAuth2ResourceServerConfigurer, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.warn("Could not access field 'jwtConfigurer' of {} via reflection", (Object)OAuth2ResourceServerConfigurer.class.getName(), (Object)e);
            }
            return result;
        });
    }

    private void configureLogin(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties, Environment environment) throws Exception {
        RestTemplate restTemplate = OktaOAuth2ResourceServerAutoConfig.restTemplate(oktaOAuth2Properties);
        http.oauth2Login().tokenEndpoint().accessTokenResponseClient(this.accessTokenResponseClient(restTemplate));
        String redirectUriProperty = environment.getProperty("spring.security.oauth2.client.registration.okta.redirect-uri");
        if (redirectUriProperty != null) {
            String redirectUri = redirectUriProperty.replace("{baseUrl}", "");
            http.oauth2Login().redirectionEndpoint().baseUri(redirectUri);
        }
    }

    private void configureResourceServerForJwtValidation(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties) throws Exception {
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)new OktaJwtAuthenticationConverter(oktaOAuth2Properties.getGroupsClaim()));
    }

    private void configureResourceServerForOpaqueTokenValidation(HttpSecurity http, OktaOAuth2Properties oktaOAuth2Properties) throws Exception {
        if (!Strings.isEmpty((Object)oktaOAuth2Properties.getClientId()) && !Strings.isEmpty((Object)oktaOAuth2Properties.getClientSecret())) {
            this.unsetJwtConfigurer((OAuth2ResourceServerConfigurer)http.getConfigurer(OAuth2ResourceServerConfigurer.class));
            http.oauth2ResourceServer().opaqueToken();
        }
    }

    private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient(RestTemplate restTemplate) {
        DefaultAuthorizationCodeTokenResponseClient accessTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        accessTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return accessTokenResponseClient;
    }
}

