/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.TokenUtil;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

final class OktaJwtAuthenticationConverter
extends JwtAuthenticationConverter {
    private final String groupClaim;

    public OktaJwtAuthenticationConverter(String groupClaim) {
        this.groupClaim = groupClaim;
    }

    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        HashSet<GrantedAuthority> result = new HashSet<GrantedAuthority>(super.extractAuthorities(jwt));
        result.addAll(TokenUtil.tokenClaimsToAuthorities(jwt.getClaims(), this.groupClaim));
        return result;
    }
}

