/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth.env;

import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.commons.configcheck.ValidationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class OktaEnvironmentPostProcessorApplicationListener
implements SmartApplicationListener,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(OktaEnvironmentPostProcessorApplicationListener.class);

    public void onApplicationEvent(ApplicationEvent event) {
        ConfigurableEnvironment environment;
        ValidationResponse validationResponse;
        if (event instanceof ApplicationPreparedEvent && !(validationResponse = ConfigurationValidator.validateIssuer((String)(environment = ((ApplicationPreparedEvent)event).getApplicationContext().getEnvironment()).getProperty("okta.oauth2.issuer"))).isValid()) {
            log.warn(validationResponse.getMessage() + System.lineSeparator() + "To fix this add the `okta.oauth2.issuer` property to your application environments.");
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

