/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.exception.UnsupportedInstantiationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ArrayUtils {
    public static boolean allEquals(Object ... array) {
        Arguments.requireNotNull(array, "array");
        if (array.length == 0) {
            return false;
        }
        if (array.length == 1) {
            return true;
        }
        if (array.length == 2) {
            return Objects.equals(array[0], array[1]);
        }
        Object element0 = array[0];
        for (int i = 1; i < array.length; ++i) {
            Object elementI = array[i];
            if (Objects.equals(element0, elementI)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyEquals(Object ... array) {
        Arguments.requireNotNull(array, "array");
        if (array.length == 0 || array.length == 1) {
            return false;
        }
        if (array.length == 2) {
            return Objects.equals(array[0], array[1]);
        }
        for (int i = 0; i < array.length - 1; ++i) {
            Object elementI = array[i];
            for (int j = i + 1; j < array.length; ++j) {
                Object elementJ = array[j];
                if (!Objects.equals(elementI, elementJ)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> Map<T, Integer> countOccurrences(T ... array) {
        Arguments.requireNotNull(array, "array");
        if (array.length == 0) {
            return Collections.emptyMap();
        }
        if (array.length == 1) {
            return Collections.singletonMap(array[0], 1);
        }
        HashMap<T, Integer> occurrences = new HashMap<T, Integer>();
        for (int i = 0; i < array.length - 1; ++i) {
            T elementI = array[i];
            if (occurrences.containsKey(elementI)) continue;
            for (int j = i + 1; j < array.length; ++j) {
                T elementJ = array[j];
                if (!Objects.equals(elementI, elementJ)) continue;
                occurrences.put(elementI, occurrences.getOrDefault(elementI, 0) + 1);
            }
        }
        return Collections.unmodifiableMap(occurrences);
    }

    public static <T> T[] map(T[] array, Function<? super T, ? extends T> mapper) {
        Arguments.requireNotNull(array, "array");
        for (int i = 0; i < array.length; ++i) {
            array[i] = mapper.apply(array[i]);
        }
        return array;
    }

    public static <T, R> R[] mapTo(T[] array, Function<? super T, ? extends R> mapper) {
        Arguments.requireNotNull(array, "array");
        Arguments.requireNotNull(mapper, "mapper");
        Object[] result = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    public static <T> Optional<T> max(T[] array, Comparator<? super T> comparator) {
        Arguments.requireNotNull(array, "array");
        if (array.length == 0) {
            return Optional.empty();
        }
        if (array.length == 1) {
            return Optional.of(array[0]);
        }
        Arguments.requireNotNull(comparator, "comparator");
        T max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = comparator.compare(array[i], max) > 0 ? array[i] : max;
        }
        return Optional.of(max);
    }

    public static <T extends Comparable<T>> Optional<T> max(T[] array) {
        return ArrayUtils.max(array, Comparable::compareTo);
    }

    public static <T> Optional<T> min(T[] array, Comparator<? super T> comparator) {
        Arguments.requireNotNull(array, "array");
        if (array.length == 0) {
            return Optional.empty();
        }
        if (array.length == 1) {
            return Optional.of(array[0]);
        }
        Arguments.requireNotNull(comparator, "comparator");
        T min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = comparator.compare(array[i], min) < 0 ? array[i] : min;
        }
        return Optional.of(min);
    }

    public static <T extends Comparable<T>> Optional<T> min(T[] array) {
        return ArrayUtils.min(array, Comparable::compareTo);
    }

    public static <T> boolean allMatch(T[] array, Predicate<? super T> predicate) {
        Arguments.requireNotNull(array, "array");
        Arguments.requireNotNull(predicate, "predicate");
        for (T element : array) {
            if (predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(T[] array, Predicate<? super T> predicate) {
        Arguments.requireNotNull(array, "array");
        Arguments.requireNotNull(predicate, "predicate");
        for (T element : array) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean noneMatch(T[] array, Predicate<? super T> predicate) {
        Arguments.requireNotNull(array, "array");
        Arguments.requireNotNull(predicate, "predicate");
        for (T element : array) {
            if (!predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> void forEach(T[] array, Consumer<T> consumer) {
        Arguments.requireNotNull(array, "array");
        Arguments.requireNotNull(consumer, "consumer");
        for (T element : array) {
            consumer.accept(element);
        }
    }

    public static boolean isEmpty(Object[] array) {
        return Arguments.requireNotNull(array, "array").length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> T[][] deepClone(T[][] matrix) {
        if (matrix == null) {
            return null;
        }
        return (Object[][])Arrays.stream(matrix).map(element -> element != null ? (Object[])element.clone() : null).toArray($ -> (Object[][])matrix.clone());
    }

    public static int[][] deepClone(int[][] matrix) {
        if (matrix == null) {
            return null;
        }
        return (int[][])Arrays.stream(matrix).map(element -> element != null ? (int[])element.clone() : null).toArray($ -> (int[][])matrix.clone());
    }

    private ArrayUtils() {
        throw new UnsupportedInstantiationException();
    }
}

