/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language;

import com.oliveryasuna.commons.language.ArrayUtils;
import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.exception.UnsupportedInstantiationException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class ConsumerUtls {
    public static <T> Consumer<T> andThen(Consumer<T> consumer, Consumer<T> ... others) {
        Arguments.requireNotNull(consumer, "consumer");
        Arguments.requireNotContainsSame(others, null, "others");
        if (others == null) {
            return consumer;
        }
        return t -> {
            consumer.accept(t);
            ArrayUtils.forEach(others, other -> other.accept(t));
        };
    }

    public static <T, U> BiConsumer<T, U> andThen(BiConsumer<T, U> biConsumer, BiConsumer<? super T, ? super U> ... others) {
        Arguments.requireNotNull(biConsumer, "biConsumer");
        Arguments.requireNotContainsSame(others, null, "others");
        if (others == null) {
            return biConsumer;
        }
        return (t, u) -> {
            biConsumer.accept(t, u);
            ArrayUtils.forEach(others, other -> other.accept(t, u));
        };
    }

    public static <T, U> BiConsumer<T, U> andThenT(BiConsumer<T, U> biConsumer, Consumer<? super T> ... consumers) {
        Arguments.requireNotNull(biConsumer, "biConsumer");
        Arguments.requireNotContainsSame(consumers, null, "consumers");
        if (consumers == null) {
            return biConsumer;
        }
        return (t, u) -> {
            biConsumer.accept(t, u);
            ArrayUtils.forEach(consumers, consumer -> consumer.accept(t));
        };
    }

    public static <T, U> BiConsumer<T, U> andThenU(BiConsumer<T, U> biConsumer, Consumer<? super U> ... consumers) {
        Arguments.requireNotNull(biConsumer, "biConsumer");
        Arguments.requireNotContainsSame(consumers, null, "consumers");
        if (consumers == null) {
            return biConsumer;
        }
        return (t, u) -> {
            biConsumer.accept(t, u);
            ArrayUtils.forEach(consumers, consumer -> consumer.accept(u));
        };
    }

    private ConsumerUtls() {
        throw new UnsupportedInstantiationException();
    }
}

