/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.exception.UnsupportedInstantiationException;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class PredicateUtils {
    public static boolean alwaysTrue(Object ignored) {
        return true;
    }

    public static boolean alwaysFalse(Object ignored) {
        return false;
    }

    public static <T> Predicate<T> and(Predicate<T> predicate, Predicate<? super T> ... others) {
        Arguments.requireNotNull(predicate, "predicate");
        Arguments.requireNotContainsSame(others, null, "others");
        if (others == null) {
            return predicate;
        }
        return t -> {
            if (!predicate.test(t)) {
                return false;
            }
            for (Predicate other : others) {
                if (other.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> or(Predicate<T> predicate, Predicate<? super T> ... others) {
        Arguments.requireNotNull(predicate, "predicate");
        Arguments.requireNotContainsSame(others, null, "others");
        if (others == null) {
            return predicate;
        }
        return t -> {
            if (predicate.test(t)) {
                return true;
            }
            for (Predicate other : others) {
                if (!other.test(t)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T, U> BiPredicate<T, U> and(BiPredicate<T, U> biPredicate, BiPredicate<? super T, ? super U> ... others) {
        Arguments.requireNotNull(biPredicate, "biPredicate");
        Arguments.requireNotContainsSame(others, null, "others");
        if (others == null) {
            return biPredicate;
        }
        return (t, u) -> {
            if (!biPredicate.test(t, u)) {
                return false;
            }
            for (BiPredicate other : others) {
                if (other.test(t, u)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T, U> BiPredicate<T, U> andT(BiPredicate<T, U> biPredicate, Predicate<? super T> ... predicates) {
        Arguments.requireNotNull(biPredicate, "biPredicate");
        Arguments.requireNotContainsSame(predicates, null, "predicates");
        if (predicates == null) {
            return biPredicate;
        }
        return (t, u) -> {
            if (!biPredicate.test(t, u)) {
                return false;
            }
            for (int i = 0; i < predicates.length; ++i) {
                if (predicates[i].test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T, U> BiPredicate<T, U> andU(BiPredicate<T, U> biPredicate, Predicate<? super U> ... predicates) {
        Arguments.requireNotNull(biPredicate, "biPredicate");
        Arguments.requireNotContainsSame(predicates, null, "predicates");
        if (predicates == null) {
            return biPredicate;
        }
        return (t, u) -> {
            if (!biPredicate.test(t, u)) {
                return false;
            }
            for (int i = 0; i < predicates.length; ++i) {
                if (predicates[i].test(u)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T, U> BiPredicate<T, U> or(BiPredicate<T, U> biPredicate, BiPredicate<? super T, ? super U> ... others) {
        Arguments.requireNotNull(biPredicate, "biPredicate");
        Arguments.requireNotContainsSame(others, null, "others");
        if (others == null) {
            return biPredicate;
        }
        return (t, u) -> {
            if (biPredicate.test(t, u)) {
                return true;
            }
            for (int i = 0; i < others.length; ++i) {
                if (!others[i].test(t, u)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T, U> BiPredicate<T, U> orT(BiPredicate<T, U> biPredicate, Predicate<? super T> ... predicates) {
        Arguments.requireNotNull(biPredicate, "biPredicate");
        Arguments.requireNotContainsSame(predicates, null, "predicates");
        if (predicates == null) {
            return biPredicate;
        }
        return (t, u) -> {
            if (biPredicate.test(t, u)) {
                return true;
            }
            for (int i = 0; i < predicates.length; ++i) {
                if (!predicates[i].test(t)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T, U> BiPredicate<T, U> orU(BiPredicate<T, U> biPredicate, Predicate<? super U> ... predicates) {
        Arguments.requireNotNull(biPredicate, "biPredicate");
        Arguments.requireNotContainsSame(predicates, null, "predicates");
        if (predicates == null) {
            return biPredicate;
        }
        return (t, u) -> {
            if (biPredicate.test(t, u)) {
                return true;
            }
            for (int i = 0; i < predicates.length; ++i) {
                if (!predicates[i].test(u)) continue;
                return true;
            }
            return false;
        };
    }

    private PredicateUtils() {
        throw new UnsupportedInstantiationException();
    }
}

