/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.exception.UnsupportedInstantiationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtils {
    public static <T> Stream<T> ofIterator(Iterator<T> iterator) {
        Arguments.requireNotNull(iterator, "iterator");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Stream<T> ofNullable(T value) {
        return value != null ? Stream.of(value) : Stream.empty();
    }

    public static <T> Stream<T> reverse(Stream<T> stream) {
        LinkedList stack = new LinkedList();
        stream.forEach(stack::push);
        return stack.stream();
    }

    private StreamUtils() {
        throw new UnsupportedInstantiationException();
    }

    public static final class Iterators {
        public static <T> Iterator<T> reverseIterator(Stream<T> stream) {
            return stream.collect(java.util.stream.Collectors.toCollection(LinkedList::new)).descendingIterator();
        }

        private Iterators() {
            throw new UnsupportedInstantiationException();
        }
    }

    public static final class Collectors {
        public static <T> Collector<T, ?, Stream<T>> reverse() {
            return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toList(), list -> {
                Collections.reverse(list);
                return list.stream();
            });
        }

        public static Collector<? super Character, StringBuilder, String> joining() {
            return Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]);
        }

        public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
            return Collector.of(HashMap::new, (map, entry) -> map.put(entry.getKey(), entry.getValue()), (map1, map2) -> {
                map1.putAll(map2);
                return map1;
            }, new Collector.Characteristics[0]);
        }

        public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toUnmodifiableMap() {
            return java.util.stream.Collectors.collectingAndThen(Collectors.toMap(), Collections::unmodifiableMap);
        }

        private Collectors() {
            throw new UnsupportedInstantiationException();
        }
    }
}

