/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language.condition;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.exception.UnsupportedInstantiationException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Conditions {
    public static boolean requireTrue(boolean condition, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (!condition) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return condition;
    }

    public static boolean requireTrue(boolean condition, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireTrue(condition, () -> message, exceptionSupplier);
    }

    public static boolean requireTrue(boolean condition, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireTrue(condition, () -> null, exceptionSupplier);
    }

    public static boolean requireFalse(boolean condition, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (condition) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return condition;
    }

    public static boolean requireFalse(boolean condition, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireFalse(condition, () -> message, exceptionSupplier);
    }

    public static boolean requireFalse(boolean condition, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireFalse(condition, () -> null, exceptionSupplier);
    }

    public static boolean requireSame(boolean actual, boolean expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static boolean requireSame(boolean actual, boolean expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static boolean requireSame(boolean actual, boolean expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static byte requireSame(byte actual, byte expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static byte requireSame(byte actual, byte expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static byte requireSame(byte actual, byte expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static char requireSame(char actual, char expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static char requireSame(char actual, char expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static char requireSame(char actual, char expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static short requireSame(short actual, short expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static short requireSame(short actual, short expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static short requireSame(short actual, short expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static int requireSame(int actual, int expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static int requireSame(int actual, int expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static int requireSame(int actual, int expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static long requireSame(long actual, long expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static long requireSame(long actual, long expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static long requireSame(long actual, long expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static float requireSame(float actual, float expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static float requireSame(float actual, float expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static float requireSame(float actual, float expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static double requireSame(double actual, double expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static double requireSame(double actual, double expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static double requireSame(double actual, double expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static <T> T requireSame(T actual, Object expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual != expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T> T requireSame(T actual, Object expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static <T> T requireSame(T actual, Object expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static boolean requireNotSame(boolean actual, boolean expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static boolean requireNotSame(boolean actual, boolean expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static boolean requireNotSame(boolean actual, boolean expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static byte requireNotSame(byte actual, byte expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static byte requireNotSame(byte actual, byte expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static byte requireNotSame(byte actual, byte expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static char requireNotSame(char actual, char expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static char requireNotSame(char actual, char expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static char requireNotSame(char actual, char expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static short requireNotSame(short actual, short expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static short requireNotSame(short actual, short expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static short requireNotSame(short actual, short expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static int requireNotSame(int actual, int expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static int requireNotSame(int actual, int expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static int requireNotSame(int actual, int expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static long requireNotSame(long actual, long expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static long requireNotSame(long actual, long expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static long requireNotSame(long actual, long expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static float requireNotSame(float actual, float expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static float requireNotSame(float actual, float expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static float requireNotSame(float actual, float expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static double requireNotSame(double actual, double expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static double requireNotSame(double actual, double expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static double requireNotSame(double actual, double expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static <T> T requireNotSame(T actual, Object expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual == expected) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T> T requireNotSame(T actual, Object expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> message, exceptionSupplier);
    }

    public static <T> T requireNotSame(T actual, Object expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotSame(actual, expected, () -> null, exceptionSupplier);
    }

    public static <T> T requireEquals(T actual, Object expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (!Objects.equals(actual, expected)) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T> T requireEquals(T actual, Object expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEquals(actual, expected, () -> message, exceptionSupplier);
    }

    public static <T> T requireEquals(T actual, Object expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEquals(actual, expected, () -> null, exceptionSupplier);
    }

    public static <T> T requireNotEquals(T actual, Object expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Objects.equals(actual, expected)) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T> T requireNotEquals(T actual, Object expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEquals(actual, expected, () -> message, exceptionSupplier);
    }

    public static <T> T requireNotEquals(T actual, Object expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEquals(actual, expected, () -> null, exceptionSupplier);
    }

    public static <T> T requireNull(T object, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (object != null) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return object;
    }

    public static <T> T requireNull(T object, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNull(object, () -> message, exceptionSupplier);
    }

    public static <T> T requireNull(T object, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNull(object, () -> null, exceptionSupplier);
    }

    public static <T> T requireNotNull(T object, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (object == null) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return object;
    }

    public static <T> T requireNotNull(T object, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotNull(object, () -> message, exceptionSupplier);
    }

    public static <T> T requireNotNull(T object, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotNull(object, () -> null, exceptionSupplier);
    }

    public static byte requireGreater(byte actual, byte less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static byte requireGreater(byte actual, byte less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static byte requireGreater(byte actual, byte less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static char requireGreater(char actual, char less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static char requireGreater(char actual, char less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static char requireGreater(char actual, char less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static short requireGreater(short actual, short less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static short requireGreater(short actual, short less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static short requireGreater(short actual, short less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static int requireGreater(int actual, int less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static int requireGreater(int actual, int less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static int requireGreater(int actual, int less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static long requireGreater(long actual, long less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static long requireGreater(long actual, long less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static long requireGreater(long actual, long less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static float requireGreater(float actual, float less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static float requireGreater(float actual, float less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static float requireGreater(float actual, float less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static double requireGreater(double actual, double less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual <= less) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static double requireGreater(double actual, double less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static double requireGreater(double actual, double less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireGreater(T actual, U less, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Objects.compare(actual, less, (o1, o2) -> Arguments.requireNotNull(o1, "actual").compareTo(o2)) <= 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T extends Comparable<T>, U extends T> T requireGreater(T actual, U less, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> message, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireGreater(T actual, U less, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, () -> null, exceptionSupplier);
    }

    public static <T, U extends T> T requireGreater(T actual, U less, Comparator<T> comparator, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (comparator.compare(actual, less) <= 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T, U extends T> T requireGreater(T actual, U less, Comparator<T> comparator, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, comparator, () -> message, exceptionSupplier);
    }

    public static <T, U extends T> T requireGreater(T actual, U less, Comparator<T> comparator, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(actual, less, comparator, () -> null, exceptionSupplier);
    }

    public static int requireGreater(int result, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (result <= 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return result;
    }

    public static int requireGreater(int result, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(result, () -> message, exceptionSupplier);
    }

    public static int requireGreater(int result, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreater(result, () -> null, exceptionSupplier);
    }

    public static byte requireLess(byte actual, byte greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static byte requireLess(byte actual, byte greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static byte requireLess(byte actual, byte greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static char requireLess(char actual, char greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static char requireLess(char actual, char greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static char requireLess(char actual, char greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static short requireLess(short actual, short greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static short requireLess(short actual, short greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static short requireLess(short actual, short greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static int requireLess(int actual, int greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static int requireLess(int actual, int greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static int requireLess(int actual, int greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static long requireLess(long actual, long greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static long requireLess(long actual, long greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static long requireLess(long actual, long greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static float requireLess(float actual, float greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static float requireLess(float actual, float greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static float requireLess(float actual, float greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static double requireLess(double actual, double greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual >= greater) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static double requireLess(double actual, double greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static double requireLess(double actual, double greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireLess(T actual, U greater, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Objects.compare(actual, greater, (o1, o2) -> Arguments.requireNotNull(o1, "actual").compareTo(o2)) >= 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T extends Comparable<T>, U extends T> T requireLess(T actual, U greater, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> message, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireLess(T actual, U greater, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, () -> null, exceptionSupplier);
    }

    public static <T, U extends T> T requireLess(T actual, U greater, Comparator<T> comparator, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (comparator.compare(actual, greater) >= 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T, U extends T> T requireLess(T actual, U greater, Comparator<T> comparator, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, comparator, () -> message, exceptionSupplier);
    }

    public static <T, U extends T> T requireLess(T actual, U greater, Comparator<T> comparator, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(actual, greater, comparator, () -> null, exceptionSupplier);
    }

    public static int requireLess(int result, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (result >= 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return result;
    }

    public static int requireLess(int result, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(result, () -> message, exceptionSupplier);
    }

    public static int requireLess(int result, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLess(result, () -> null, exceptionSupplier);
    }

    public static byte requireGreaterOrSame(byte actual, byte lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static byte requireGreaterOrSame(byte actual, byte lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static byte requireGreaterOrSame(byte actual, byte lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static char requireGreaterOrSame(char actual, char lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static char requireGreaterOrSame(char actual, char lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static char requireGreaterOrSame(char actual, char lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static short requireGreaterOrSame(short actual, short lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static short requireGreaterOrSame(short actual, short lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static short requireGreaterOrSame(short actual, short lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static int requireGreaterOrSame(int actual, int lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static int requireGreaterOrSame(int actual, int lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static int requireGreaterOrSame(int actual, int lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static long requireGreaterOrSame(long actual, long lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static long requireGreaterOrSame(long actual, long lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static long requireGreaterOrSame(long actual, long lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static float requireGreaterOrSame(float actual, float lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static float requireGreaterOrSame(float actual, float lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static float requireGreaterOrSame(float actual, float lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static double requireGreaterOrSame(double actual, double lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual < lessOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static double requireGreaterOrSame(double actual, double lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static double requireGreaterOrSame(double actual, double lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireGreaterOrSame(T actual, U lessOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Objects.compare(actual, lessOrSame, (o1, o2) -> Arguments.requireNotNull(o1, "actual").compareTo(o2)) < 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T extends Comparable<T>, U extends T> T requireGreaterOrSame(T actual, U lessOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> message, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireGreaterOrSame(T actual, U lessOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, () -> null, exceptionSupplier);
    }

    public static <T, U extends T> T requireGreaterOrSame(T actual, U lessOrSame, Comparator<T> comparator, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (comparator.compare(actual, lessOrSame) < 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T, U extends T> T requireGreaterOrSame(T actual, U lessOrSame, Comparator<T> comparator, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, comparator, () -> message, exceptionSupplier);
    }

    public static <T, U extends T> T requireGreaterOrSame(T actual, U lessOrSame, Comparator<T> comparator, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(actual, lessOrSame, comparator, () -> null, exceptionSupplier);
    }

    public static int requireGreaterOrSame(int result, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (result < 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return result;
    }

    public static int requireGreaterOrSame(int result, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(result, () -> message, exceptionSupplier);
    }

    public static int requireGreaterOrSame(int result, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireGreaterOrSame(result, () -> null, exceptionSupplier);
    }

    public static byte requireLessOrSame(byte actual, byte greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static byte requireLessOrSame(byte actual, byte greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static byte requireLessOrSame(byte actual, byte greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static char requireLessOrSame(char actual, char greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static char requireLessOrSame(char actual, char greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static char requireLessOrSame(char actual, char greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static short requireLessOrSame(short actual, short greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static short requireLessOrSame(short actual, short greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static short requireLessOrSame(short actual, short greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static int requireLessOrSame(int actual, int greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static int requireLessOrSame(int actual, int greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static int requireLessOrSame(int actual, int greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static long requireLessOrSame(long actual, long greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static long requireLessOrSame(long actual, long greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static long requireLessOrSame(long actual, long greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static float requireLessOrSame(float actual, float greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static float requireLessOrSame(float actual, float greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static float requireLessOrSame(float actual, float greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static double requireLessOrSame(double actual, double greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (actual > greaterOrSame) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static double requireLessOrSame(double actual, double greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static double requireLessOrSame(double actual, double greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireLessOrSame(T actual, U greaterOrSame, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Objects.compare(actual, greaterOrSame, (o1, o2) -> Arguments.requireNotNull(o1, "actual").compareTo(o2)) > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T extends Comparable<T>, U extends T> T requireLessOrSame(T actual, U greaterOrSame, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> message, exceptionSupplier);
    }

    public static <T extends Comparable<T>, U extends T> T requireLessOrSame(T actual, U greaterOrSame, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, () -> null, exceptionSupplier);
    }

    public static <T, U extends T> T requireLessOrSame(T actual, U greaterOrSame, Comparator<T> comparator, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (comparator.compare(actual, greaterOrSame) > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return actual;
    }

    public static <T, U extends T> T requireLessOrSame(T actual, U greaterOrSame, Comparator<T> comparator, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, comparator, () -> message, exceptionSupplier);
    }

    public static <T, U extends T> T requireLessOrSame(T actual, U greaterOrSame, Comparator<T> comparator, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(actual, greaterOrSame, comparator, () -> null, exceptionSupplier);
    }

    public static int requireLessOrSame(int result, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (result > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return result;
    }

    public static int requireLessOrSame(int result, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(result, () -> message, exceptionSupplier);
    }

    public static int requireLessOrSame(int result, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireLessOrSame(result, () -> null, exceptionSupplier);
    }

    public static boolean[] requireEmpty(boolean[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static boolean[] requireEmpty(boolean[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static boolean[] requireEmpty(boolean[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static byte[] requireEmpty(byte[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static byte[] requireEmpty(byte[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static byte[] requireEmpty(byte[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static char[] requireEmpty(char[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static char[] requireEmpty(char[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static char[] requireEmpty(char[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static short[] requireEmpty(short[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static short[] requireEmpty(short[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static short[] requireEmpty(short[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static int[] requireEmpty(int[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static int[] requireEmpty(int[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static int[] requireEmpty(int[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static long[] requireEmpty(long[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static long[] requireEmpty(long[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static long[] requireEmpty(long[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static float[] requireEmpty(float[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static float[] requireEmpty(float[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static float[] requireEmpty(float[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static double[] requireEmpty(double[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static double[] requireEmpty(double[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static double[] requireEmpty(double[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static <T> T[] requireEmpty(T[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length > 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static <T> T[] requireEmpty(T[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> message, exceptionSupplier);
    }

    public static <T> T[] requireEmpty(T[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(array, () -> null, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireEmpty(T iterable, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(iterable, "iterable").iterator().hasNext()) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return iterable;
    }

    public static <T extends Iterable<U>, U> T requireEmpty(T iterable, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(iterable, () -> message, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireEmpty(T iterable, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(iterable, () -> null, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireEmpty(T collection, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (!Arguments.requireNotNull(collection, "collection").isEmpty()) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return collection;
    }

    public static <T extends Collection<U>, U> T requireEmpty(T collection, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(collection, () -> message, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireEmpty(T collection, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(collection, () -> null, exceptionSupplier);
    }

    public static String requireEmpty(String string, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (!Arguments.requireNotNull(string, "string").isEmpty()) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return string;
    }

    public static String requireEmpty(String string, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(string, () -> message, exceptionSupplier);
    }

    public static String requireEmpty(String string, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireEmpty(string, () -> null, exceptionSupplier);
    }

    public static boolean[] requireNotEmpty(boolean[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static boolean[] requireNotEmpty(boolean[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static boolean[] requireNotEmpty(boolean[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static byte[] requireNotEmpty(byte[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static byte[] requireNotEmpty(byte[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static byte[] requireNotEmpty(byte[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static char[] requireNotEmpty(char[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static char[] requireNotEmpty(char[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static char[] requireNotEmpty(char[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static short[] requireNotEmpty(short[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static short[] requireNotEmpty(short[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static short[] requireNotEmpty(short[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static int[] requireNotEmpty(int[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static int[] requireNotEmpty(int[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static int[] requireNotEmpty(int[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static long[] requireNotEmpty(long[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static long[] requireNotEmpty(long[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static long[] requireNotEmpty(long[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static float[] requireNotEmpty(float[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static float[] requireNotEmpty(float[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static float[] requireNotEmpty(float[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static double[] requireNotEmpty(double[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static double[] requireNotEmpty(double[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static double[] requireNotEmpty(double[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static <T> T[] requireNotEmpty(T[] array, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(array, "array").length == 0) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static <T> T[] requireNotEmpty(T[] array, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> message, exceptionSupplier);
    }

    public static <T> T[] requireNotEmpty(T[] array, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(array, () -> null, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireNotEmpty(T iterable, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (!Arguments.requireNotNull(iterable, "iterable").iterator().hasNext()) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return iterable;
    }

    public static <T extends Iterable<U>, U> T requireNotEmpty(T iterable, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(iterable, () -> message, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireNotEmpty(T iterable, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(iterable, () -> null, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireNotEmpty(T collection, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(collection, "collection").isEmpty()) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return collection;
    }

    public static <T extends Collection<U>, U> T requireNotEmpty(T collection, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(collection, () -> message, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireNotEmpty(T collection, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(collection, () -> null, exceptionSupplier);
    }

    public static String requireNotEmpty(String string, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (Arguments.requireNotNull(string, "string").isEmpty()) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return string;
    }

    public static String requireNotEmpty(String string, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(string, () -> message, exceptionSupplier);
    }

    public static String requireNotEmpty(String string, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotEmpty(string, () -> null, exceptionSupplier);
    }

    public static <T> T[] requireContainsEquals(T[] array, T expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (T element : array) {
            if (!Objects.equals(element, expected)) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static <T> T[] requireContainsEquals(T[] array, T expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsEquals(array, expected, () -> message, exceptionSupplier);
    }

    public static <T> T[] requireContainsEquals(T[] array, T expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsEquals(array, expected, () -> null, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireContainsEquals(T iterable, U expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(iterable, "iterable");
        for (U element : iterable) {
            if (!Objects.equals(element, expected)) continue;
            return iterable;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static <T extends Iterable<U>, U> T requireContainsEquals(T iterable, U expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsEquals(iterable, expected, () -> message, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireContainsEquals(T iterable, U expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsEquals(iterable, expected, () -> null, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireContainsEquals(T collection, U expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(collection, "collected");
        for (U element : collection) {
            if (!Objects.equals(element, expected)) continue;
            return collection;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static <T extends Collection<U>, U> T requireContainsEquals(T collection, U expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsEquals(collection, expected, () -> message, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireContainsEquals(T collection, U expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsEquals(collection, expected, () -> null, exceptionSupplier);
    }

    public static <T> T[] requireNotContainsEquals(T[] array, T unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (T element : array) {
            if (!Objects.equals(element, unexpected)) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static <T> T[] requireNotContainsEquals(T[] array, T unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsEquals(array, unexpected, () -> message, exceptionSupplier);
    }

    public static <T> T[] requireNotContainsEquals(T[] array, T unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsEquals(array, unexpected, () -> null, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireNotContainsEquals(T iterable, U unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(iterable, "iterable");
        for (U element : iterable) {
            if (!Objects.equals(element, unexpected)) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return iterable;
    }

    public static <T extends Iterable<U>, U> T requireNotContainsEquals(T iterable, U unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsEquals(iterable, unexpected, () -> message, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireNotContainsEquals(T iterable, U unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsEquals(iterable, unexpected, () -> null, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireNotContainsEquals(T collection, U unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (collection.contains(unexpected)) {
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return collection;
    }

    public static <T extends Collection<U>, U> T requireNotContainsEquals(T collection, U unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsEquals(collection, unexpected, () -> message, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireNotContainsEquals(T collection, U unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsEquals(collection, unexpected, () -> null, exceptionSupplier);
    }

    public static boolean[] requireContainsSame(boolean[] array, boolean expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (boolean element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static boolean[] requireContainsSame(boolean[] array, boolean expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static boolean[] requireContainsSame(boolean[] array, boolean expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static byte[] requireContainsSame(byte[] array, byte expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (byte element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static byte[] requireContainsSame(byte[] array, byte expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static byte[] requireContainsSame(byte[] array, byte expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static char[] requireContainsSame(char[] array, char expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (char element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static char[] requireContainsSame(char[] array, char expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static char[] requireContainsSame(char[] array, char expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static short[] requireContainsSame(short[] array, short expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (short element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static short[] requireContainsSame(short[] array, short expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static short[] requireContainsSame(short[] array, short expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static int[] requireContainsSame(int[] array, int expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (int element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static int[] requireContainsSame(int[] array, int expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static int[] requireContainsSame(int[] array, int expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static long[] requireContainsSame(long[] array, long expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (long element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static long[] requireContainsSame(long[] array, long expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static long[] requireContainsSame(long[] array, long expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static float[] requireContainsSame(float[] array, float expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (float element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static float[] requireContainsSame(float[] array, float expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static float[] requireContainsSame(float[] array, float expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static double[] requireContainsSame(double[] array, double expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (double element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static double[] requireContainsSame(double[] array, double expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static double[] requireContainsSame(double[] array, double expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static <T> T[] requireContainsSame(T[] array, T expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (T element : array) {
            if (element != expected) continue;
            return array;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static <T> T[] requireContainsSame(T[] array, T expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> message, exceptionSupplier);
    }

    public static <T> T[] requireContainsSame(T[] array, T expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, expected, () -> null, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireContainsSame(T iterable, U expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(iterable, "iterable");
        for (U element : iterable) {
            if (element != expected) continue;
            return iterable;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static <T extends Iterable<U>, U> T requireContainsSame(T iterable, U expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(iterable, expected, () -> message, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireContainsSame(T iterable, U expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(iterable, expected, () -> null, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireContainsSame(T collection, U expected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(collection, "collected");
        for (U element : collection) {
            if (element != expected) continue;
            return collection;
        }
        Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        throw new IllegalStateException();
    }

    public static <T extends Collection<U>, U> T requireContainsSame(T collection, U expected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(collection, expected, () -> message, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireContainsSame(T collection, U expected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(collection, expected, () -> null, exceptionSupplier);
    }

    public static boolean[] requireNotContainsSame(boolean[] array, boolean unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (boolean element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static boolean[] requireNotContainsSame(boolean[] array, boolean unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static boolean[] requireNotContainsSame(boolean[] array, boolean unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static byte[] requireNotContainsSame(byte[] array, byte unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (byte element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static byte[] requireNotContainsSame(byte[] array, byte unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static byte[] requireNotContainsSame(byte[] array, byte unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static char[] requireNotContainsSame(char[] array, char unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (char element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static char[] requireNotContainsSame(char[] array, char unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static char[] requireNotContainsSame(char[] array, char unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static short[] requireNotContainsSame(short[] array, short unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (short element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static short[] requireNotContainsSame(short[] array, short unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static short[] requireNotContainsSame(short[] array, short unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static int[] requireNotContainsSame(int[] array, int unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (int element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static int[] requireNotContainsSame(int[] array, int unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static int[] requireNotContainsSame(int[] array, int unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static long[] requireNotContainsSame(long[] array, long unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (long element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static long[] requireNotContainsSame(long[] array, long unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static long[] requireNotContainsSame(long[] array, long unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static float[] requireNotContainsSame(float[] array, float unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (float element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static float[] requireNotContainsSame(float[] array, float unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static float[] requireNotContainsSame(float[] array, float unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static double[] requireNotContainsSame(double[] array, double unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (double element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static double[] requireNotContainsSame(double[] array, double unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static double[] requireNotContainsSame(double[] array, double unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static <T> T[] requireNotContainsSame(T[] array, T unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(array, "array");
        for (T element : array) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return array;
    }

    public static <T> T[] requireNotContainsSame(T[] array, T unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, unexpected, () -> message, exceptionSupplier);
    }

    public static <T> T[] requireNotContainsSame(T[] array, T unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireContainsSame(array, unexpected, () -> null, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireNotContainsSame(T iterable, U unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(iterable, "iterable");
        for (U element : iterable) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return iterable;
    }

    public static <T extends Iterable<U>, U> T requireNotContainsSame(T iterable, U unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(iterable, unexpected, () -> message, exceptionSupplier);
    }

    public static <T extends Iterable<U>, U> T requireNotContainsSame(T iterable, U unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(iterable, unexpected, () -> null, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireNotContainsSame(T collection, U unexpected, Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        Arguments.requireNotNull(collection, "collected");
        for (U element : collection) {
            if (element != unexpected) continue;
            Conditions.throwWithMessageSupplier(messageSupplier, exceptionSupplier);
        }
        return collection;
    }

    public static <T extends Collection<U>, U> T requireNotContainsSame(T collection, U unexpected, String message, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(collection, unexpected, () -> message, exceptionSupplier);
    }

    public static <T extends Collection<U>, U> T requireNotContainsSame(T collection, U unexpected, Function<String, RuntimeException> exceptionSupplier) {
        return Conditions.requireNotContainsSame(collection, unexpected, () -> null, exceptionSupplier);
    }

    private static void throwWithMessageSupplier(Supplier<String> messageSupplier, Function<String, RuntimeException> exceptionSupplier) {
        if (messageSupplier == null) {
            messageSupplier = () -> null;
        }
        if (exceptionSupplier == null) {
            exceptionSupplier = RuntimeException::new;
        }
        throw exceptionSupplier.apply(messageSupplier.get());
    }

    private Conditions() {
        throw new UnsupportedInstantiationException();
    }
}

