/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language.pattern.registry;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.pattern.Registration;
import com.oliveryasuna.commons.language.pattern.registry.MultiRegistry;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;

public class MapMultiRegistry<K, V extends Collection<Object>>
implements MultiRegistry<K> {
    protected final Map<K, V> registrations;
    protected final Supplier<V> valuesSupplier;

    public MapMultiRegistry(Supplier<? extends Map<K, V>> mapSupplier, Supplier<V> valuesSupplier) {
        this.registrations = Arguments.requireNotNull(Arguments.requireNotNull(mapSupplier, "mapSupplier").get(), "mapSupplier.get()");
        this.valuesSupplier = Arguments.requireNotNull(valuesSupplier, "valuesSupplier");
    }

    @Override
    public Registration register(K key, Object value) {
        this.registrations.putIfAbsent(key, (Collection)this.valuesSupplier.get());
        ((Collection)this.registrations.get(key)).add(value);
        return () -> this.unregister(key, value);
    }

    @Override
    public Iterator<Object> unregister(K key) {
        Iterator<Object> values = this.forKey(key);
        values.forEachRemaining(value -> this.unregister(key, value));
        return values;
    }

    @Override
    public void unregister(K key, Object value) {
        if (!this.registrations.containsKey(key)) {
            return;
        }
        Iterator iter = ((Collection)this.registrations.get(key)).iterator();
        while (iter.hasNext()) {
            if (!value.equals(iter.next())) continue;
            iter.remove();
            return;
        }
    }

    @Override
    public int unregisterAll(K key, Object value) {
        if (!this.registrations.containsKey(key)) {
            return 0;
        }
        int count = 0;
        Iterator iter = ((Collection)this.registrations.get(key)).iterator();
        while (iter.hasNext()) {
            if (!value.equals(iter.next())) continue;
            iter.remove();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Object> forKey(K key) {
        return this.registrations.getOrDefault(key, (Collection)this.valuesSupplier.get()).iterator();
    }

    @Override
    public boolean contains(K key) {
        return this.registrations.containsKey(key);
    }

    @Override
    public int count(K key) {
        if (this.registrations.containsKey(key)) {
            return ((Collection)this.registrations.get(key)).size();
        }
        return 0;
    }
}

