/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language.pattern.registry;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.pattern.Registration;
import com.oliveryasuna.commons.language.pattern.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MapRegistry<K>
implements Registry<K> {
    protected final Map<K, Object> registrations;

    public MapRegistry(Supplier<? extends Map<K, Object>> mapSupplier) {
        this.registrations = Arguments.requireNotNull(Arguments.requireNotNull(mapSupplier, "mapSupplier").get(), "mapSupplier.get()");
    }

    public MapRegistry() {
        this(HashMap::new);
    }

    @Override
    public Registration register(K key, Object value) {
        if (this.registrations.containsKey(key)) {
            throw new IllegalArgumentException("Already registered.");
        }
        this.registrations.put(key, value);
        return () -> this.unregister(key);
    }

    @Override
    public <V> V unregister(K key, Class<V> type) {
        return type.cast(this.unregister(key));
    }

    @Override
    public Object unregister(K key) {
        if (!this.registrations.containsKey(key)) {
            throw new IllegalArgumentException("Not registered.");
        }
        return this.registrations.remove(key);
    }

    @Override
    public <V> Optional<V> forKey(K key, Class<V> type) {
        return this.forKey(key).map(type::cast);
    }

    @Override
    public Optional<Object> forKey(K key) {
        if (this.registrations.containsKey(key)) {
            return Optional.of(this.registrations.get(key));
        }
        return Optional.empty();
    }

    @Override
    public boolean contains(K key) {
        return this.registrations.containsKey(key);
    }
}

