/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language.scalar;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.scalar.Scalar;

public class Or
implements Scalar<Boolean> {
    private final Scalar<Boolean>[] scalars;

    public Or(Scalar<Boolean> scalar, Scalar<Boolean> ... scalars) {
        Arguments.requireNotNull(scalar);
        Arguments.requireNotNull(scalars, "scalars");
        Arguments.requireNotContainsSame(scalars, null, "scalars");
        this.scalars = new Scalar[1 + scalars.length];
        this.scalars[0] = scalar;
        System.arraycopy(scalars, 0, this.scalars, 1, scalars.length);
    }

    @Override
    public Boolean value() throws Exception {
        for (Scalar<Boolean> scalar : this.scalars) {
            if (!scalar.value().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

