/*
 * Decompiled with CFR 0.152.
 */
package com.oliveryasuna.commons.language.scalar;

import com.oliveryasuna.commons.language.condition.Arguments;
import com.oliveryasuna.commons.language.scalar.Scalar;

public class Xor
implements Scalar<Boolean> {
    private final Scalar<Boolean>[] scalars;

    public Xor(Scalar<Boolean> scalar, Scalar<Boolean> ... scalars) {
        Arguments.requireNotNull(scalar);
        Arguments.requireNotNull(scalars, "scalars");
        Arguments.requireNotContainsSame(scalars, null, "scalars");
        this.scalars = new Scalar[1 + scalars.length];
        this.scalars[0] = scalar;
        System.arraycopy(scalars, 0, this.scalars, 1, scalars.length);
    }

    @Override
    public Boolean value() throws Exception {
        boolean result = this.scalars[0].value();
        for (int i = 1; i < this.scalars.length; ++i) {
            Scalar<Boolean> scalar = this.scalars[i];
            result ^= scalar.value().booleanValue();
        }
        return result;
    }
}

