/*
 * Decompiled with CFR 0.152.
 */
package com.omarsmak.kafka.consumer.lag.monitoring.client.impl;

import com.omarsmak.kafka.consumer.lag.monitoring.client.KafkaConsumerLagClient;
import com.omarsmak.kafka.consumer.lag.monitoring.client.data.Lag;
import com.omarsmak.kafka.consumer.lag.monitoring.client.data.Offsets;
import com.omarsmak.kafka.consumer.lag.monitoring.client.exceptions.KafkaConsumerLagClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH$J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\fH\u0002J\"\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/omarsmak/kafka/consumer/lag/monitoring/client/impl/AbstractKafkaConsumerLagClient;", "Lcom/omarsmak/kafka/consumer/lag/monitoring/client/KafkaConsumerLagClient;", "kafkaConsumerClient", "Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "", "(Lorg/apache/kafka/clients/consumer/KafkaConsumer;)V", "calculateLagPerPartitionAndTotalLag", "Lkotlin/Pair;", "", "", "", "topicOffsets", "Lcom/omarsmak/kafka/consumer/lag/monitoring/client/data/Offsets;", "consumerOffsets", "close", "", "closeClients", "getConsumerLag", "", "Lcom/omarsmak/kafka/consumer/lag/monitoring/client/data/Lag;", "consumerGroup", "getConsumerLagPerTopic", "getConsumerMemberLag", "getTopicOffsets", "topicName", "monitoring-client"})
public abstract class AbstractKafkaConsumerLagClient
implements KafkaConsumerLagClient {
    private final KafkaConsumer<String, String> kafkaConsumerClient;

    protected abstract void closeClients();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Offsets getTopicOffsets(@NotNull String topicName) {
        void $this$mapTo$iv$iv;
        TopicPartition topicPartition;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List partitions;
        Intrinsics.checkNotNullParameter((Object)topicName, (String)"topicName");
        List list = this.kafkaConsumerClient.partitionsFor(topicName);
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = partitions = CollectionsKt.emptyList();
        }
        if (partitions.isEmpty()) {
            throw (Throwable)new KafkaConsumerLagClientException("Topic `" + topicName + "` does not exist in the Kafka cluster.");
        }
        Iterable $this$map$iv = partitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            PartitionInfo partitionInfo = (PartitionInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            topicPartition = new TopicPartition(it.topic(), it.partition());
            collection.add(topicPartition);
        }
        List topicPartition2 = (List)destination$iv$iv;
        Map map = this.kafkaConsumerClient.endOffsets((Collection)topicPartition2);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"kafkaConsumerClient.endOffsets(topicPartition)");
        Map $this$map$iv2 = map;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        void var10_15 = $this$mapTo$iv$iv;
        boolean bl3 = false;
        Iterator iterator = var10_15.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            topicPartition = TuplesKt.to((Object)((TopicPartition)it.getKey()).partition(), it.getValue());
            collection.add(topicPartition);
        }
        Map topicOffsetsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        return new Offsets(topicName, topicOffsetsMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Lag> getConsumerLag(@NotNull String consumerGroup) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)consumerGroup, (String)"consumerGroup");
        List<Offsets> consumerOffsets = this.getConsumerOffsets(consumerGroup);
        Iterable $this$map$iv = consumerOffsets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Offsets offsets = (Offsets)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Lag lag = this.getConsumerLagPerTopic((Offsets)it);
            collection.add(lag);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void close() {
        this.kafkaConsumerClient.wakeup();
        this.closeClients();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<Lag>> getConsumerMemberLag(@NotNull String consumerGroup) {
        void $this$mapValuesTo$iv$iv;
        Map<String, List<Offsets>> consumerMemberOffsets;
        Intrinsics.checkNotNullParameter((Object)consumerGroup, (String)"consumerGroup");
        Map<String, List<Offsets>> $this$mapValues$iv = consumerMemberOffsets = this.getConsumerGroupMembersOffsets(consumerGroup);
        boolean $i$f$mapValues = false;
        Map<String, List<Offsets>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Offsets offsets = (Offsets)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Lag lag = this.getConsumerLagPerTopic((Offsets)it2);
                collection.add(lag);
            }
            List list = (List)destination$iv$iv2;
            map3.put(k2, list);
        }
        return destination$iv$iv;
    }

    private final Lag getConsumerLagPerTopic(Offsets consumerOffsets) {
        Offsets topicOffsets = this.getTopicOffsets(consumerOffsets.getTopicName());
        Pair<Map<Integer, Long>, Long> lagPerPartitionAndTotalLag = this.calculateLagPerPartitionAndTotalLag(topicOffsets, consumerOffsets);
        Map lagPerPartition = (Map)lagPerPartitionAndTotalLag.getFirst();
        long totalLag = ((Number)lagPerPartitionAndTotalLag.getSecond()).longValue();
        return new Lag(topicOffsets.getTopicName(), totalLag, lagPerPartition, topicOffsets.getOffsetPerPartition(), consumerOffsets.getOffsetPerPartition());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Map<Integer, Long>, Long> calculateLagPerPartitionAndTotalLag(Offsets topicOffsets, Offsets consumerOffsets) {
        void $this$mapTo$iv$iv;
        long totalLag = 0L;
        Map<Integer, Long> $this$map$iv = consumerOffsets.getOffsetPerPartition();
        boolean $i$f$map = false;
        Map<Integer, Long> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_9 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_9.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var15_15 = $dstr$k$v;
            boolean bl3 = false;
            int n = ((Number)var15_15.getKey()).intValue();
            var15_15 = $dstr$k$v;
            bl3 = false;
            long v = ((Number)var15_15.getValue()).longValue();
            long lag = ((Number)MapsKt.getValue(topicOffsets.getOffsetPerPartition(), (Object)((int)k))).longValue() - v;
            totalLag += lag;
            Pair pair = TuplesKt.to((Object)((int)k), (Object)lag);
            collection.add(pair);
        }
        Map lagPerPartition = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return TuplesKt.to((Object)lagPerPartition, (Object)totalLag);
    }

    public AbstractKafkaConsumerLagClient(@NotNull KafkaConsumer<String, String> kafkaConsumerClient) {
        Intrinsics.checkNotNullParameter(kafkaConsumerClient, (String)"kafkaConsumerClient");
        this.kafkaConsumerClient = kafkaConsumerClient;
    }
}

