/*
 * Decompiled with CFR 0.152.
 */
package com.omarsmak.kafka.consumer.lag.monitoring.client.impl;

import com.omarsmak.kafka.consumer.lag.monitoring.client.data.Offsets;
import com.omarsmak.kafka.consumer.lag.monitoring.client.exceptions.KafkaConsumerLagClientException;
import com.omarsmak.kafka.consumer.lag.monitoring.client.impl.AbstractKafkaConsumerLagClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\"\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/omarsmak/kafka/consumer/lag/monitoring/client/impl/KafkaConsumerLagJavaClient;", "Lcom/omarsmak/kafka/consumer/lag/monitoring/client/impl/AbstractKafkaConsumerLagClient;", "javaAdminClient", "Lorg/apache/kafka/clients/admin/AdminClient;", "kafkaConsumerClient", "Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "", "(Lorg/apache/kafka/clients/admin/AdminClient;Lorg/apache/kafka/clients/consumer/KafkaConsumer;)V", "closeClients", "", "getConsumerGroupMembersOffsets", "", "", "Lcom/omarsmak/kafka/consumer/lag/monitoring/client/data/Offsets;", "consumerGroup", "getConsumerGroupsList", "getConsumerOffsetPerMember", "topicPartition", "Lorg/apache/kafka/common/TopicPartition;", "getConsumerOffsets", "getConsumerOffsetsPerTopic", "offsets", "Lorg/apache/kafka/clients/consumer/OffsetAndMetadata;", "monitoring-client"})
public final class KafkaConsumerLagJavaClient
extends AbstractKafkaConsumerLagClient {
    private final AdminClient javaAdminClient;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getConsumerGroupsList() {
        void $this$mapTo$iv$iv;
        Object object = this.javaAdminClient.listConsumerGroups().all().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaAdminClient.listConsumerGroups().all().get()");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConsumerGroupListing consumerGroupListing = (ConsumerGroupListing)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.groupId();
            collection.add(string);
        }
        List consumerList = (List)destination$iv$iv;
        if (consumerList.isEmpty()) {
            throw (Throwable)new KafkaConsumerLagClientException("No consumers existing in the Kafka cluster.");
        }
        return consumerList;
    }

    @Override
    @NotNull
    public List<Offsets> getConsumerOffsets(@NotNull String consumerGroup) {
        Intrinsics.checkNotNullParameter((Object)consumerGroup, (String)"consumerGroup");
        Map map = (Map)this.javaAdminClient.listConsumerGroupOffsets(consumerGroup).partitionsToOffsetAndMetadata().get();
        if (map == null) {
            throw (Throwable)new KafkaConsumerLagClientException("Consumer group `" + consumerGroup + "` does not exist in the Kafka cluster.");
        }
        Map offsets = map;
        return this.getConsumerOffsetsPerTopic(offsets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<Offsets>> getConsumerGroupMembersOffsets(@NotNull String consumerGroup) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)consumerGroup, (String)"consumerGroup");
        Map map = (Map)this.javaAdminClient.describeConsumerGroups((Collection)CollectionsKt.listOf((Object)consumerGroup)).all().get();
        if (map == null) {
            throw (Throwable)new KafkaConsumerLagClientException("Consumer group `" + consumerGroup + "` does not exist in the Kafka cluster.");
        }
        Map consumerGroupMembersEnvelope = map;
        ConsumerGroupDescription consumerGroupDescription = (ConsumerGroupDescription)CollectionsKt.firstOrNull((Iterable)consumerGroupMembersEnvelope.values());
        if (consumerGroupDescription == null) {
            throw (Throwable)new KafkaConsumerLagClientException("Consumer group `" + consumerGroup + "` and its members does not exist in the Kafka cluster.");
        }
        ConsumerGroupDescription consumerGroupMembers = consumerGroupDescription;
        Collection collection = consumerGroupMembers.members();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"consumerGroupMembers\n                .members()");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MemberDescription memberDescription = (MemberDescription)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it.consumerId();
            Set set = it.assignment().topicPartitions();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.assignment().topicPartitions()");
            Pair pair = TuplesKt.to((Object)string, this.getConsumerOffsetPerMember(consumerGroup, CollectionsKt.toList((Iterable)set)));
            collection2.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final List<Offsets> getConsumerOffsetPerMember(String consumerGroup, List<TopicPartition> topicPartition) {
        Map map = (Map)this.javaAdminClient.listConsumerGroupOffsets(consumerGroup, new ListConsumerGroupOffsetsOptions().topicPartitions(topicPartition)).partitionsToOffsetAndMetadata().get();
        if (map == null) {
            throw (Throwable)new KafkaConsumerLagClientException("Consumer group `" + consumerGroup + "` does not exist in the Kafka cluster.");
        }
        Map offsets = map;
        return this.getConsumerOffsetsPerTopic(offsets);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Offsets> getConsumerOffsetsPerTopic(Map<TopicPartition, ? extends OffsetAndMetadata> offsets) {
        void $this$mapTo$iv$iv;
        Map.Entry<String, Map> $this$getOrPut$iv;
        boolean bl = false;
        Map rawOffsets = new LinkedHashMap();
        Map<TopicPartition, ? extends OffsetAndMetadata> $this$filterValues$iv = offsets;
        boolean $i$f$filterValues = false;
        Map<TopicPartition, OffsetAndMetadata> result$iv = new LinkedHashMap();
        Map<TopicPartition, ? extends OffsetAndMetadata> map = $this$filterValues$iv;
        boolean bl2 = false;
        for (Map.Entry<TopicPartition, ? extends OffsetAndMetadata> entry$iv : map.entrySet()) {
            OffsetAndMetadata it = entry$iv.getValue();
            boolean bl3 = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        result$iv = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator = result$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String key$iv;
            void t;
            Map.Entry element$iv;
            Map.Entry $dstr$t$u = element$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry bl3 = $dstr$t$u;
            boolean bl6 = false;
            TopicPartition topicPartition = (TopicPartition)bl3.getKey();
            bl3 = $dstr$t$u;
            bl6 = false;
            OffsetAndMetadata u = (OffsetAndMetadata)bl3.getValue();
            Map map2 = rawOffsets;
            Intrinsics.checkNotNullExpressionValue((Object)t.topic(), (String)"t.topic()");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl7 = false;
                boolean bl8 = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map offsetPerPartition = (Map)object;
            Integer n = t.partition();
            OffsetAndMetadata offsetAndMetadata = u;
            Intrinsics.checkNotNull((Object)offsetAndMetadata);
            offsetPerPartition.putIfAbsent(n, offsetAndMetadata.offset());
            rawOffsets.replace(t.topic(), offsetPerPartition);
        }
        Map $this$map$iv = rawOffsets;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<TopicPartition, ? extends OffsetAndMetadata>> iterator2 = $this$mapTo$iv$iv;
        boolean bl9 = false;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            void it;
            Map.Entry<String, Map> item$iv$iv;
            $this$getOrPut$iv = item$iv$iv = iterator3.next();
            Collection collection = destination$iv$iv;
            boolean bl10 = false;
            Offsets offsets2 = new Offsets((String)it.getKey(), (Map)it.getValue());
            collection.add(offsets2);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void closeClients() {
        this.javaAdminClient.close();
    }

    public KafkaConsumerLagJavaClient(@NotNull AdminClient javaAdminClient, @NotNull KafkaConsumer<String, String> kafkaConsumerClient) {
        Intrinsics.checkNotNullParameter((Object)javaAdminClient, (String)"javaAdminClient");
        Intrinsics.checkNotNullParameter(kafkaConsumerClient, (String)"kafkaConsumerClient");
        super(kafkaConsumerClient);
        this.javaAdminClient = javaAdminClient;
    }
}

