/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.omdbapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.omertron.omdbapi.OMDBException;
import com.omertron.omdbapi.model.OmdbVideoBasic;
import com.omertron.omdbapi.model.OmdbVideoFull;
import com.omertron.omdbapi.model.SearchResults;
import com.omertron.omdbapi.tools.OmdbBuilder;
import com.omertron.omdbapi.tools.OmdbParameters;
import com.omertron.omdbapi.tools.OmdbUrlBuilder;
import com.omertron.omdbapi.tools.Param;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.exception.ApiExceptionType;
import org.yamj.api.common.http.DigestedResponse;
import org.yamj.api.common.http.DigestedResponseReader;
import org.yamj.api.common.http.SimpleHttpClientBuilder;

public class OmdbApi {
    private static final Logger LOG = LoggerFactory.getLogger(OmdbApi.class);
    private final HttpClient httpClient;
    private static ObjectMapper mapper = new ObjectMapper();
    private static final int HTTP_STATUS_300 = 300;
    private static final int HTTP_STATUS_500 = 500;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Charset charset;
    private String apiKey;

    public OmdbApi() {
        this((HttpClient)new SimpleHttpClientBuilder().build());
    }

    public OmdbApi(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.charset = Charset.forName(DEFAULT_CHARSET);
    }

    public OmdbApi(String apiKey) {
        this((HttpClient)new SimpleHttpClientBuilder().build());
        this.apiKey = apiKey;
    }

    private String requestWebPage(URL url) throws OMDBException {
        LOG.trace("Requesting: {}", (Object)url.toString());
        try {
            HttpGet httpGet = new HttpGet(url.toURI());
            httpGet.addHeader("accept", "application/json");
            DigestedResponse response = DigestedResponseReader.requestContent((HttpClient)this.httpClient, (HttpGet)httpGet, (Charset)this.charset);
            if (response.getStatusCode() >= 500) {
                throw new OMDBException(ApiExceptionType.HTTP_503_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            if (response.getStatusCode() >= 300) {
                throw new OMDBException(ApiExceptionType.HTTP_404_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            return response.getContent();
        }
        catch (URISyntaxException ex) {
            throw new OMDBException(ApiExceptionType.INVALID_URL, "Invalid URL", url, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new OMDBException(ApiExceptionType.CONNECTION_ERROR, "Error retrieving URL", url, (Throwable)ex);
        }
    }

    public SearchResults search(OmdbParameters searchParams) throws OMDBException {
        SearchResults resultList;
        searchParams.add(Param.APIKEY, this.apiKey);
        String url = OmdbUrlBuilder.create(searchParams);
        LOG.info("URL: {}", (Object)url);
        String jsonData = this.requestWebPage(OmdbUrlBuilder.generateUrl(url));
        try {
            resultList = (SearchResults)mapper.readValue(jsonData, SearchResults.class);
        }
        catch (IOException ex) {
            throw new OMDBException(ApiExceptionType.MAPPING_FAILED, jsonData, 0, url, (Throwable)ex);
        }
        return resultList;
    }

    public OmdbVideoFull FullTitleSearch(String title, int year) throws OMDBException {
        return this.getInfo(new OmdbBuilder().setApiKey(this.apiKey).setTitle(title).setPlotFull().setYear(year).build());
    }

    public OmdbVideoBasic ShortTitleSearch(String title, int year) throws OMDBException {
        return this.getInfo(new OmdbBuilder().setApiKey(this.apiKey).setTitle(title).setPlotShort().setYear(year).build());
    }

    public SearchResults search(String title) throws OMDBException {
        return this.search(new OmdbBuilder().setApiKey(this.apiKey).setSearchTerm(title).build());
    }

    public SearchResults search(String title, int year) throws OMDBException {
        return this.search(new OmdbBuilder().setApiKey(this.apiKey).setSearchTerm(title).setYear(year).build());
    }

    public OmdbVideoFull getInfo(OmdbParameters parameters) throws OMDBException {
        OmdbVideoFull result;
        parameters.add(Param.APIKEY, this.apiKey);
        URL url = OmdbUrlBuilder.createUrl(parameters);
        String jsonData = this.requestWebPage(url);
        try {
            result = (OmdbVideoFull)mapper.readValue(jsonData, OmdbVideoFull.class);
            if (result == null || !result.isResponse()) {
                throw new OMDBException(ApiExceptionType.ID_NOT_FOUND, result == null ? "No data returned" : result.getError());
            }
        }
        catch (IOException ex) {
            throw new OMDBException(ApiExceptionType.MAPPING_FAILED, jsonData, 0, url, (Throwable)ex);
        }
        return result;
    }
}

