/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.omdbapi.tools;

import com.omertron.omdbapi.OMDBException;
import com.omertron.omdbapi.emumerations.PlotType;
import com.omertron.omdbapi.emumerations.ResultType;
import com.omertron.omdbapi.tools.OmdbParameters;
import com.omertron.omdbapi.tools.Param;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.exception.ApiExceptionType;

public final class OmdbBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OmdbBuilder.class);
    private final OmdbParameters params = new OmdbParameters();
    private static final boolean DEFAULT_TOMATOES = Boolean.FALSE;

    public OmdbBuilder setSearchTerm(String searchTerm) throws OMDBException {
        if (StringUtils.isBlank((CharSequence)searchTerm)) {
            throw new OMDBException(ApiExceptionType.UNKNOWN_CAUSE, "Must provide a search term!");
        }
        this.params.add(Param.SEARCH, searchTerm);
        return this;
    }

    public OmdbBuilder setImdbId(String imdbId) throws OMDBException {
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            throw new OMDBException(ApiExceptionType.UNKNOWN_CAUSE, "Must provide an IMDB ID!");
        }
        this.params.add(Param.IMDB, imdbId);
        return this;
    }

    public OmdbBuilder setTitle(String title) throws OMDBException {
        if (StringUtils.isBlank((CharSequence)title)) {
            throw new OMDBException(ApiExceptionType.UNKNOWN_CAUSE, "Must provide a title!");
        }
        this.params.add(Param.TITLE, title);
        return this;
    }

    public OmdbBuilder setYear(int year) {
        if (year > 0) {
            this.params.add(Param.YEAR, year);
        }
        return this;
    }

    public OmdbBuilder setResultType(ResultType resultType) {
        if (!ResultType.isDefault(resultType)) {
            this.params.add(Param.RESULT, (Object)resultType);
        }
        return this;
    }

    public OmdbBuilder setTypeMovie() {
        if (!ResultType.isDefault(ResultType.MOVIE)) {
            this.params.add(Param.RESULT, (Object)ResultType.MOVIE);
        }
        return this;
    }

    public OmdbBuilder setTypeSeries() {
        if (!ResultType.isDefault(ResultType.SERIES)) {
            this.params.add(Param.RESULT, (Object)ResultType.SERIES);
        }
        return this;
    }

    public OmdbBuilder setTypeEpisode() {
        if (!ResultType.isDefault(ResultType.EPISODE)) {
            this.params.add(Param.RESULT, (Object)ResultType.EPISODE);
        }
        return this;
    }

    public OmdbBuilder setPlot(PlotType plotType) {
        if (!PlotType.isDefault(plotType)) {
            this.params.add(Param.PLOT, (Object)plotType);
        }
        return this;
    }

    @Deprecated
    public OmdbBuilder setPlotLong() {
        this.setPlotFull();
        return this;
    }

    public OmdbBuilder setPlotFull() {
        if (!PlotType.isDefault(PlotType.FULL)) {
            this.params.add(Param.PLOT, (Object)PlotType.FULL);
        }
        return this;
    }

    public OmdbBuilder setPlotShort() {
        if (!PlotType.isDefault(PlotType.SHORT)) {
            this.params.add(Param.PLOT, (Object)PlotType.SHORT);
        }
        return this;
    }

    public OmdbBuilder setTomatoes(boolean tomatoes) {
        if (DEFAULT_TOMATOES != tomatoes) {
            this.params.add(Param.TOMATOES, tomatoes);
        }
        return this;
    }

    public OmdbBuilder setTomatoesOn() {
        return this.setTomatoes(true);
    }

    public OmdbBuilder setTomatoesOff() {
        return this.setTomatoes(false);
    }

    public OmdbBuilder setVersion(int version) {
        this.params.add(Param.VERSION, version);
        return this;
    }

    public OmdbBuilder setApiKey(String apiKey) throws OMDBException {
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new OMDBException(ApiExceptionType.AUTH_FAILURE, "Must provide an ApiKey");
        }
        this.params.add(Param.APIKEY, apiKey);
        return this;
    }

    public OmdbParameters build() {
        LOG.trace(this.toString());
        return this.params;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this.params, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

