/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.omdbapi.tools;

import com.omertron.omdbapi.OMDBException;
import com.omertron.omdbapi.emumerations.PlotType;
import com.omertron.omdbapi.tools.OmdbParameters;
import com.omertron.omdbapi.tools.Param;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.exception.ApiExceptionType;

public class OmdbUrlBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OmdbUrlBuilder.class);
    private static final String BASE_URL = "http://www.omdbapi.com/";
    private static final String DELIMITER_FIRST = "?";
    private static final String DELIMITER_SUBSEQUENT = "&";

    private OmdbUrlBuilder() {
        throw new UnsupportedOperationException("Class cannot be initialised");
    }

    public static String create(OmdbParameters params) throws OMDBException {
        StringBuilder sb = new StringBuilder(BASE_URL);
        sb.append(DELIMITER_FIRST);
        if (!params.has(Param.APIKEY)) {
            throw new OMDBException(ApiExceptionType.AUTH_FAILURE, "Must include an ApiKey to make a call");
        }
        String apikey = (String)params.get(Param.APIKEY);
        sb.append(Param.APIKEY.getValue()).append(apikey);
        sb.append(DELIMITER_SUBSEQUENT);
        if (params.has(Param.SEARCH)) {
            String search = (String)params.get(Param.SEARCH);
            sb.append(Param.SEARCH.getValue()).append(search.replace(" ", "+"));
        } else if (params.has(Param.IMDB)) {
            sb.append(Param.IMDB.getValue()).append(params.get(Param.IMDB));
        } else if (params.has(Param.TITLE)) {
            String title = (String)params.get(Param.TITLE);
            sb.append(Param.TITLE.getValue()).append(title.replace(" ", "+"));
        } else {
            throw new OMDBException(ApiExceptionType.INVALID_URL, "Must include a search or ID");
        }
        OmdbUrlBuilder.appendParam(params, Param.YEAR, sb);
        if (params.has(Param.PLOT) && (PlotType)((Object)params.get(Param.PLOT)) != PlotType.getDefault()) {
            OmdbUrlBuilder.appendParam(params, Param.PLOT, sb);
        }
        OmdbUrlBuilder.appendParam(params, Param.TOMATOES, sb);
        OmdbUrlBuilder.appendParam(params, Param.RESULT, sb);
        OmdbUrlBuilder.appendParam(params, Param.DATA, sb);
        OmdbUrlBuilder.appendParam(params, Param.VERSION, sb);
        OmdbUrlBuilder.appendParam(params, Param.CALLBACK, sb);
        LOG.trace("Created URL: {}", (Object)sb.toString());
        return sb.toString();
    }

    public static URL createUrl(OmdbParameters params) throws OMDBException {
        return OmdbUrlBuilder.generateUrl(OmdbUrlBuilder.create(params));
    }

    private static void appendParam(OmdbParameters params, Param key, StringBuilder sb) {
        if (params.has(key)) {
            sb.append(DELIMITER_SUBSEQUENT).append(key.getValue()).append(params.get(key));
        }
    }

    public static URL generateUrl(String url) throws OMDBException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new OMDBException(ApiExceptionType.INVALID_URL, "Failed to create URL", url, (Throwable)ex);
        }
    }
}

