/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import com.android.ometriasdk.core.LocalCacheExtensionKt;
import com.android.ometriasdk.core.event.OmetriaEvent;
import com.android.ometriasdk.core.network.DeserializationExtensionsKt;
import com.android.ometriasdk.core.network.SerializationExtensionsKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\b\u0010\u000f\u001a\u0004\u0018\u00010\bJ\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u0004\u0018\u00010\bJ\b\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u0019\u001a\u00020\nJ\u0006\u0010\u001a\u001a\u00020\nJ\u0014\u0010\u001b\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\bJ\u0010\u0010\"\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010\bJ\u000e\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0013J\u0010\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\bJ\u000e\u0010(\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\bJ\u001e\u0010,\u001a\u00020\f2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010.\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/ometriasdk/core/LocalCache;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "localCacheEncryptedPreferences", "Landroid/content/SharedPreferences;", "masterKey", "", "areNotificationsEnabled", "", "clearEvents", "", "clearProfileIdentifiedData", "getApiToken", "getCustomerId", "getEmail", "getEvents", "", "Lcom/android/ometriasdk/core/event/OmetriaEvent;", "getInstallationId", "getLocalCachePreferences", "getLocalEncryptedCachePreferences", "getPushToken", "getSdkVersionRN", "isFirstAppRun", "isFirstPermissionsUpdateEvent", "removeEvents", "eventsToRemove", "saveApiToken", "apiToken", "saveAreNotificationsEnabled", "saveCustomerId", "customerId", "saveEmail", "email", "saveEvent", "ometriaEvent", "saveInstallationId", "installationId", "saveIsFirstAppRun", "saveIsFirstPermissionsUpdateEvent", "savePushToken", "pushToken", "updateEvents", "events", "isBeingFlushed", "OmetriaSDK_release"})
@SourceDebugExtension(value={"SMAP\nLocalCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalCache.kt\ncom/android/ometriasdk/core/LocalCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1855#2:178\n288#2,2:179\n1856#2:181\n1855#2:182\n288#2,2:183\n1856#2:185\n*S KotlinDebug\n*F\n+ 1 LocalCache.kt\ncom/android/ometriasdk/core/LocalCache\n*L\n94#1:178\n95#1:179,2\n94#1:181\n107#1:182\n108#1:183,2\n107#1:185\n*E\n"})
public final class LocalCache {
    @NotNull
    private final Context context;
    @NotNull
    private final String masterKey;
    @NotNull
    private SharedPreferences localCacheEncryptedPreferences;

    public LocalCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        String string = MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrCreate(MasterKeys.AES256_GCM_SPEC)");
        this.masterKey = string;
        SharedPreferences localCachePreferences = this.getLocalCachePreferences();
        this.localCacheEncryptedPreferences = this.getLocalEncryptedCachePreferences();
        Map map = localCachePreferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"localCachePreferences.all");
        if (!map.isEmpty()) {
            LocalCacheExtensionKt.copyTo(localCachePreferences, this.localCacheEncryptedPreferences);
            LocalCacheExtensionKt.clear(localCachePreferences);
        }
    }

    private final SharedPreferences getLocalCachePreferences() {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("LOCAL_CACHE_PREFERENCES", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ES, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    private final SharedPreferences getLocalEncryptedCachePreferences() {
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)"LOCAL_ENCRYPTED_CACHE_PREFERENCES", (String)this.masterKey, (Context)this.context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            LOCA\u2026heme.AES256_GCM\n        )");
        return sharedPreferences;
    }

    public final void saveIsFirstAppRun(boolean isFirstAppRun) {
        this.localCacheEncryptedPreferences.edit().putBoolean("IS_FIRST_APP_RUN_KEY", isFirstAppRun).apply();
    }

    public final boolean isFirstAppRun() {
        return this.localCacheEncryptedPreferences.getBoolean("IS_FIRST_APP_RUN_KEY", true);
    }

    public final void saveInstallationId(@Nullable String installationId) {
        this.localCacheEncryptedPreferences.edit().putString("INSTALLATION_ID_KEY", installationId).apply();
    }

    @Nullable
    public final String getInstallationId() {
        return this.localCacheEncryptedPreferences.getString("INSTALLATION_ID_KEY", null);
    }

    public final void saveEvent(@NotNull OmetriaEvent ometriaEvent) {
        Intrinsics.checkNotNullParameter((Object)ometriaEvent, (String)"ometriaEvent");
        String string = this.localCacheEncryptedPreferences.getString("EVENTS_KEY", "[]");
        if (string == null) {
            string = "[]";
        }
        String eventsString = string;
        List<OmetriaEvent> eventsList = DeserializationExtensionsKt.toOmetriaEventList(eventsString);
        eventsList.add(ometriaEvent);
        this.localCacheEncryptedPreferences.edit().putString("EVENTS_KEY", SerializationExtensionsKt.toJson((Collection<OmetriaEvent>)eventsList).toString()).apply();
    }

    @NotNull
    public final List<OmetriaEvent> getEvents() {
        String string = this.localCacheEncryptedPreferences.getString("EVENTS_KEY", null);
        if (string == null) {
            string = "[]";
        }
        String eventsString = string;
        return DeserializationExtensionsKt.toOmetriaEventList(eventsString);
    }

    public final void updateEvents(@Nullable List<OmetriaEvent> events, boolean isBeingFlushed) {
        if (events == null) {
            return;
        }
        List<OmetriaEvent> cachedEvents = this.getEvents();
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            block3: {
                OmetriaEvent event = (OmetriaEvent)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = cachedEvents;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    OmetriaEvent it = (OmetriaEvent)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getEventId(), (Object)event.getEventId())) continue;
                    v0 = element$iv2;
                    break block3;
                }
                v0 = null;
            }
            OmetriaEvent ometriaEvent = v0;
            if (ometriaEvent == null) continue;
            ometriaEvent.setBeingFlushed(isBeingFlushed);
        }
        this.localCacheEncryptedPreferences.edit().putString("EVENTS_KEY", SerializationExtensionsKt.toJson((Collection<OmetriaEvent>)cachedEvents).toString()).apply();
    }

    public final void removeEvents(@NotNull List<OmetriaEvent> eventsToRemove) {
        Intrinsics.checkNotNullParameter(eventsToRemove, (String)"eventsToRemove");
        List eventsList = CollectionsKt.toMutableList((Collection)this.getEvents());
        Iterable $this$forEach$iv = eventsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            Collection collection;
            block2: {
                OmetriaEvent event = (OmetriaEvent)element$iv;
                boolean bl = false;
                collection = eventsList;
                Iterable $this$firstOrNull$iv = eventsList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    OmetriaEvent it = (OmetriaEvent)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getEventId(), (Object)event.getEventId())) continue;
                    v0 = element$iv2;
                    break block2;
                }
                v0 = null;
            }
            Object var10_10 = v0;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(var10_10);
        }
        this.localCacheEncryptedPreferences.edit().putString("EVENTS_KEY", SerializationExtensionsKt.toJson(eventsList).toString()).apply();
    }

    public final void savePushToken(@NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        this.localCacheEncryptedPreferences.edit().putString("PUSH_TOKEN_KEY", pushToken).apply();
    }

    @Nullable
    public final String getPushToken() {
        return this.localCacheEncryptedPreferences.getString("PUSH_TOKEN_KEY", null);
    }

    public final void clearEvents() {
        this.localCacheEncryptedPreferences.edit().remove("EVENTS_KEY").apply();
    }

    public final void saveCustomerId(@Nullable String customerId) {
        this.localCacheEncryptedPreferences.edit().putString("CUSTOMER_ID_KEY", customerId).apply();
    }

    @Nullable
    public final String getCustomerId() {
        return this.localCacheEncryptedPreferences.getString("CUSTOMER_ID_KEY", null);
    }

    public final void saveEmail(@Nullable String email) {
        this.localCacheEncryptedPreferences.edit().putString("EMAIL_KEY", email).apply();
    }

    @Nullable
    public final String getEmail() {
        return this.localCacheEncryptedPreferences.getString("EMAIL_KEY", null);
    }

    public final void clearProfileIdentifiedData() {
        this.localCacheEncryptedPreferences.edit().remove("CUSTOMER_ID_KEY").apply();
        this.localCacheEncryptedPreferences.edit().remove("EMAIL_KEY").apply();
    }

    public final void saveAreNotificationsEnabled(boolean areNotificationsEnabled) {
        this.localCacheEncryptedPreferences.edit().putBoolean("ARE_NOTIFICATIONS_ENABLED_KEY", areNotificationsEnabled).apply();
    }

    public final boolean areNotificationsEnabled() {
        return this.localCacheEncryptedPreferences.getBoolean("ARE_NOTIFICATIONS_ENABLED_KEY", true);
    }

    public final void saveIsFirstPermissionsUpdateEvent(boolean isFirstPermissionsUpdateEvent) {
        this.localCacheEncryptedPreferences.edit().putBoolean("IS_FIRST_PERMISSION_UPDATE_EVENT_KEY", isFirstPermissionsUpdateEvent).apply();
    }

    public final boolean isFirstPermissionsUpdateEvent() {
        return this.localCacheEncryptedPreferences.getBoolean("IS_FIRST_PERMISSION_UPDATE_EVENT_KEY", true);
    }

    @Nullable
    public final String getSdkVersionRN() {
        return this.localCacheEncryptedPreferences.getString("SDK_VERSION_RN_KEY", null);
    }

    public final void saveApiToken(@NotNull String apiToken) {
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        this.localCacheEncryptedPreferences.edit().putString("API_TOKEN_KEY", apiToken).apply();
    }

    @Nullable
    public final String getApiToken() {
        return this.localCacheEncryptedPreferences.getString("API_TOKEN_KEY", null);
    }
}

