/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.URLUtil;
import androidx.core.app.NotificationManagerCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.android.ometriasdk.core.LocalCache;
import com.android.ometriasdk.core.Logger;
import com.android.ometriasdk.core.Ometria;
import com.android.ometriasdk.core.OmetriaConfig;
import com.android.ometriasdk.core.Repository;
import com.android.ometriasdk.core.event.EventHandler;
import com.android.ometriasdk.core.event.OmetriaBasket;
import com.android.ometriasdk.core.event.OmetriaEventType;
import com.android.ometriasdk.core.listener.ProcessAppLinkListener;
import com.android.ometriasdk.core.network.Client;
import com.android.ometriasdk.core.network.ConnectionFactory;
import com.android.ometriasdk.core.network.DeserializationExtensionsKt;
import com.android.ometriasdk.core.network.OmetriaThreadPoolExecutor;
import com.android.ometriasdk.lifecycle.OmetriaActivityLifecycleHelper;
import com.android.ometriasdk.notification.NotificationHandler;
import com.android.ometriasdk.notification.OmetriaNotification;
import com.android.ometriasdk.notification.OmetriaNotificationBody;
import com.android.ometriasdk.notification.OmetriaNotificationInteractionHandler;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001e\u0018\u0000 o2\u00020\u0001:\u0002opB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\r\u0010\u001b\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0010\u0010,\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020#J\u0016\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\u0019H\u0002J\b\u00102\u001a\u00020\nH\u0002J\r\u00103\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b4J\r\u00105\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b6J\r\u00107\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b8J\r\u00109\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b:J-\u0010;\u001a\u00020\u00192\b\u0010<\u001a\u0004\u0018\u00010&2\u0014\b\u0002\u0010=\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>H\u0000\u00a2\u0006\u0002\b@J\u000e\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020\u0019J\u000e\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020&J$\u0010G\u001a\u00020\u00192\u0006\u0010H\u001a\u00020&2\u0014\b\u0002\u0010=\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>J\u0018\u0010I\u001a\u00020\u00192\b\u0010J\u001a\u0004\u0018\u00010&2\u0006\u0010K\u001a\u00020&J3\u0010L\u001a\u00020\u00192\u0006\u0010M\u001a\u00020&2\b\u0010N\u001a\u0004\u0018\u00010&2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>H\u0000\u00a2\u0006\u0002\bPJ(\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020S2\u0016\b\u0002\u0010T\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?\u0018\u00010>H\u0002J\u0006\u0010U\u001a\u00020\u0019J!\u0010V\u001a\u00020\u00192\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>H\u0000\u00a2\u0006\u0002\bXJ!\u0010Y\u001a\u00020\u00192\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>H\u0000\u00a2\u0006\u0002\bZJ\u001a\u0010[\u001a\u00020\u00192\u0006\u0010F\u001a\u00020&2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010CJ\u0015\u0010\\\u001a\u00020\u00192\u0006\u0010]\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b^J(\u0010_\u001a\u00020\u00192\n\b\u0002\u0010`\u001a\u0004\u0018\u00010&2\u0014\b\u0002\u0010a\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>J\u000e\u0010b\u001a\u00020\u00192\u0006\u0010c\u001a\u00020&J\u0006\u0010d\u001a\u00020\u0019J\u000e\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020&J\u000e\u0010g\u001a\u00020\u00192\u0006\u0010h\u001a\u00020&J\u0017\u0010i\u001a\u00020\u00192\b\u0010j\u001a\u0004\u0018\u00010&H\u0000\u00a2\u0006\u0002\bkJ$\u0010l\u001a\u00020\u00192\u0006\u0010<\u001a\u00020&2\u0014\b\u0002\u0010=\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>J\u0010\u0010m\u001a\u00020\u00192\u0006\u0010c\u001a\u00020&H\u0007J\u0010\u0010n\u001a\u00020\u00192\u0006\u0010c\u001a\u00020&H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/android/ometriasdk/core/Ometria;", "Lcom/android/ometriasdk/notification/OmetriaNotificationInteractionHandler;", "()V", "activityLifecycleHelper", "Lcom/android/ometriasdk/lifecycle/OmetriaActivityLifecycleHelper;", "eventHandler", "Lcom/android/ometriasdk/core/event/EventHandler;", "executor", "Lcom/android/ometriasdk/core/network/OmetriaThreadPoolExecutor;", "isInitialized", "", "localCache", "Lcom/android/ometriasdk/core/LocalCache;", "notificationHandler", "Lcom/android/ometriasdk/notification/NotificationHandler;", "notificationInteractionHandler", "getNotificationInteractionHandler", "()Lcom/android/ometriasdk/notification/OmetriaNotificationInteractionHandler;", "setNotificationInteractionHandler", "(Lcom/android/ometriasdk/notification/OmetriaNotificationInteractionHandler;)V", "ometriaConfig", "Lcom/android/ometriasdk/core/OmetriaConfig;", "repository", "Lcom/android/ometriasdk/core/Repository;", "clear", "", "flush", "generateInstallationId", "generateInstallationId$OmetriaSDK_release", "isReactNativeUsage", "isReactNativeUsage$OmetriaSDK_release", "loggingEnabled", "enableDebugging", "onMessageReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "", "onNotificationInteracted", "onNotificationInteraction", "ometriaNotification", "Lcom/android/ometriasdk/notification/OmetriaNotification;", "onNotificationReceived", "parseNotification", "processAppLink", "url", "listener", "Lcom/android/ometriasdk/core/listener/ProcessAppLinkListener;", "retrieveFirebaseToken", "shouldGenerateInstallationId", "trackAppBackgroundedEvent", "trackAppBackgroundedEvent$OmetriaSDK_release", "trackAppForegroundedEvent", "trackAppForegroundedEvent$OmetriaSDK_release", "trackAppInstalledEvent", "trackAppInstalledEvent$OmetriaSDK_release", "trackAppLaunchedEvent", "trackAppLaunchedEvent$OmetriaSDK_release", "trackAutomatedScreenViewedEvent", "screenName", "additionalInfo", "", "", "trackAutomatedScreenViewedEvent$OmetriaSDK_release", "trackBasketUpdatedEvent", "basket", "Lcom/android/ometriasdk/core/event/OmetriaBasket;", "trackBasketViewedEvent", "trackCheckoutStartedEvent", "orderId", "trackCustomEvent", "customEventType", "trackDeepLinkOpenedEvent", "link", "page", "trackErrorOccurredEvent", "errorClass", "errorMessage", "originalMessage", "trackErrorOccurredEvent$OmetriaSDK_release", "trackEvent", "type", "Lcom/android/ometriasdk/core/event/OmetriaEventType;", "data", "trackHomeScreenViewedEvent", "trackNotificationInteractedEvent", "context", "trackNotificationInteractedEvent$OmetriaSDK_release", "trackNotificationReceivedEvent", "trackNotificationReceivedEvent$OmetriaSDK_release", "trackOrderCompletedEvent", "trackPermissionsUpdateEvent", "hasPermission", "trackPermissionsUpdateEvent$OmetriaSDK_release", "trackProductListingViewedEvent", "listingType", "listingAttributes", "trackProductViewedEvent", "productId", "trackProfileDeidentifiedEvent", "trackProfileIdentifiedByCustomerIdEvent", "customerId", "trackProfileIdentifiedByEmailEvent", "email", "trackPushTokenRefreshedEvent", "pushToken", "trackPushTokenRefreshedEvent$OmetriaSDK_release", "trackScreenViewedEvent", "trackWishlistAddedToEvent", "trackWishlistRemovedFromEvent", "Companion", "HOLDER", "OmetriaSDK_release"})
@SourceDebugExtension(value={"SMAP\nOmetria.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ometria.kt\ncom/android/ometriasdk/core/Ometria\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,539:1\n1#2:540\n*E\n"})
public final class Ometria
implements OmetriaNotificationInteractionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private OmetriaConfig ometriaConfig;
    private boolean isInitialized;
    private LocalCache localCache;
    private EventHandler eventHandler;
    private Repository repository;
    private NotificationHandler notificationHandler;
    private OmetriaThreadPoolExecutor executor;
    public OmetriaNotificationInteractionHandler notificationInteractionHandler;
    @Nullable
    private OmetriaActivityLifecycleHelper activityLifecycleHelper;
    @NotNull
    private static final Lazy<Ometria> instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);

    private Ometria() {
    }

    @NotNull
    public final OmetriaNotificationInteractionHandler getNotificationInteractionHandler() {
        OmetriaNotificationInteractionHandler ometriaNotificationInteractionHandler = this.notificationInteractionHandler;
        if (ometriaNotificationInteractionHandler != null) {
            return ometriaNotificationInteractionHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"notificationInteractionHandler");
        return null;
    }

    public final void setNotificationInteractionHandler(@NotNull OmetriaNotificationInteractionHandler ometriaNotificationInteractionHandler) {
        Intrinsics.checkNotNullParameter((Object)ometriaNotificationInteractionHandler, (String)"<set-?>");
        this.notificationInteractionHandler = ometriaNotificationInteractionHandler;
    }

    public final boolean isReactNativeUsage$OmetriaSDK_release() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        return repository.getSdkVersionRN() != null;
    }

    private final void retrieveFirebaseToken() {
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(Ometria::retrieveFirebaseToken$lambda$0);
    }

    private final boolean shouldGenerateInstallationId() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        return repository.getInstallationId() == null;
    }

    public final void generateInstallationId$OmetriaSDK_release() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String installationId = string;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        repository.saveInstallationId(installationId);
    }

    @NotNull
    public final Ometria loggingEnabled(boolean enableDebugging) {
        OmetriaConfig ometriaConfig = this.ometriaConfig;
        if (ometriaConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ometriaConfig");
            ometriaConfig = null;
        }
        ometriaConfig.setEnableDebugging(enableDebugging);
        Logger.INSTANCE.setLevel(2);
        return Ometria.Companion.getInstance();
    }

    public final void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        NotificationHandler notificationHandler = this.notificationHandler;
        if (notificationHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationHandler");
            notificationHandler = null;
        }
        NotificationHandler.handleNotification$default(notificationHandler, remoteMessage, false, 2, null);
    }

    public final void onNotificationReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        NotificationHandler notificationHandler = this.notificationHandler;
        if (notificationHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationHandler");
            notificationHandler = null;
        }
        notificationHandler.handleNotification(remoteMessage, false);
    }

    public final void onNotificationInteracted(@NotNull RemoteMessage remoteMessage) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
            OmetriaNotificationBody ometriaNotificationBody = DeserializationExtensionsKt.toOmetriaNotificationBody(remoteMessage);
            if (ometriaNotificationBody == null) break block1;
            OmetriaNotificationBody ometriaPushNotificationBody = ometriaNotificationBody;
            boolean bl = false;
            Map<String, Object> map = ometriaPushNotificationBody.getContext();
            if (map == null) {
                return;
            }
            this.trackNotificationInteractedEvent$OmetriaSDK_release(map);
        }
    }

    public final void onNewToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        LocalCache localCache = this.localCache;
        if (localCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
            localCache = null;
        }
        if (!Intrinsics.areEqual((Object)localCache.getPushToken(), (Object)token)) {
            this.trackPushTokenRefreshedEvent$OmetriaSDK_release(token);
        }
    }

    private final void trackEvent(OmetriaEventType type, Map<String, ? extends Object> data) {
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventHandler");
            eventHandler = null;
        }
        Map<String, ? extends Object> map = data;
        eventHandler.processEvent(type, map != null ? MapsKt.toMutableMap(map) : null);
    }

    static /* synthetic */ void trackEvent$default(Ometria ometria, OmetriaEventType ometriaEventType, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        ometria.trackEvent(ometriaEventType, map);
    }

    public final void trackAppInstalledEvent$OmetriaSDK_release() {
        Ometria.trackEvent$default(this, OmetriaEventType.APP_INSTALLED, null, 2, null);
    }

    public final void trackAppLaunchedEvent$OmetriaSDK_release() {
        Ometria.trackEvent$default(this, OmetriaEventType.APP_LAUNCHED, null, 2, null);
    }

    public final void trackAppForegroundedEvent$OmetriaSDK_release() {
        Ometria.trackEvent$default(this, OmetriaEventType.APP_FOREGROUNDED, null, 2, null);
    }

    public final void trackAppBackgroundedEvent$OmetriaSDK_release() {
        Ometria.trackEvent$default(this, OmetriaEventType.APP_BACKGROUNDED, null, 2, null);
    }

    public final void trackScreenViewedEvent(@NotNull String screenName, @NotNull Map<String, ? extends Object> additionalInfo) {
        Intrinsics.checkNotNullParameter((Object)screenName, (String)"screenName");
        Intrinsics.checkNotNullParameter(additionalInfo, (String)"additionalInfo");
        Map data = new LinkedHashMap();
        data.put("extra", additionalInfo);
        data.put("page", screenName);
        this.trackEvent(OmetriaEventType.SCREEN_VIEWED, data);
    }

    public static /* synthetic */ void trackScreenViewedEvent$default(Ometria ometria, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        ometria.trackScreenViewedEvent(string, map);
    }

    public final void trackAutomatedScreenViewedEvent$OmetriaSDK_release(@Nullable String screenName, @NotNull Map<String, ? extends Object> additionalInfo) {
        Intrinsics.checkNotNullParameter(additionalInfo, (String)"additionalInfo");
        Map data = MapsKt.toMutableMap(additionalInfo);
        String string = screenName;
        if (string == null) {
            string = "";
        }
        data.put("page", string);
        this.trackEvent(OmetriaEventType.SCREEN_VIEWED_AUTOMATIC, data);
    }

    public static /* synthetic */ void trackAutomatedScreenViewedEvent$OmetriaSDK_release$default(Ometria ometria, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        ometria.trackAutomatedScreenViewedEvent$OmetriaSDK_release(string, map);
    }

    public final void trackProfileIdentifiedByCustomerIdEvent(@NotNull String customerId) {
        Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
        this.trackEvent(OmetriaEventType.PROFILE_IDENTIFIED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"customerId", (Object)customerId)));
    }

    public final void trackProfileIdentifiedByEmailEvent(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.trackEvent(OmetriaEventType.PROFILE_IDENTIFIED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"email", (Object)email)));
    }

    public final void trackProfileDeidentifiedEvent() {
        Ometria.trackEvent$default(this, OmetriaEventType.PROFILE_DEIDENTIFIED, null, 2, null);
    }

    public final void trackProductViewedEvent(@NotNull String productId) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        this.trackEvent(OmetriaEventType.PRODUCT_VIEWED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"productId", (Object)productId)));
    }

    public final void trackProductListingViewedEvent(@Nullable String listingType, @NotNull Map<String, ? extends Object> listingAttributes) {
        Intrinsics.checkNotNullParameter(listingAttributes, (String)"listingAttributes");
        Map data = new LinkedHashMap();
        String string = listingType;
        if (string != null) {
            String it = string;
            boolean bl = false;
            data.put("listingType", it);
        }
        data.put("listingAttributes", listingAttributes);
        this.trackEvent(OmetriaEventType.PRODUCT_LISTING_VIEWED, data);
    }

    public static /* synthetic */ void trackProductListingViewedEvent$default(Ometria ometria, String string, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        ometria.trackProductListingViewedEvent(string, map);
    }

    @Deprecated(message="The event is no longer sent to the Ometria backend. It will be removed in a future version")
    public final void trackWishlistAddedToEvent(@NotNull String productId) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Logger.INSTANCE.d("Events", "The trackWishlistAddedToEvent event is no longer processed by Ometria. It will not produce any result.");
    }

    @Deprecated(message="The event is no longer sent to the Ometria backend. It will be removed in a future version")
    public final void trackWishlistRemovedFromEvent(@NotNull String productId) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Logger.INSTANCE.d("Events", "The trackWishlistRemovedFromEvent event is no longer processed by Ometria. It will not produce any result.");
    }

    public final void trackBasketViewedEvent() {
        Ometria.trackEvent$default(this, OmetriaEventType.BASKET_VIEWED, null, 2, null);
    }

    public final void trackBasketUpdatedEvent(@NotNull OmetriaBasket basket) {
        Intrinsics.checkNotNullParameter((Object)basket, (String)"basket");
        this.trackEvent(OmetriaEventType.BASKET_UPDATED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"basket", (Object)basket)));
    }

    public final void trackCheckoutStartedEvent(@NotNull String orderId) {
        Intrinsics.checkNotNullParameter((Object)orderId, (String)"orderId");
        this.trackEvent(OmetriaEventType.CHECKOUT_STARTED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"orderId", (Object)orderId)));
    }

    public final void trackOrderCompletedEvent(@NotNull String orderId, @Nullable OmetriaBasket basket) {
        Intrinsics.checkNotNullParameter((Object)orderId, (String)"orderId");
        Map data = new LinkedHashMap();
        data.put("orderId", orderId);
        OmetriaBasket ometriaBasket = basket;
        if (ometriaBasket != null) {
            OmetriaBasket it = ometriaBasket;
            boolean bl = false;
            data.put("basket", it);
        }
        this.trackEvent(OmetriaEventType.ORDER_COMPLETED, data);
    }

    public static /* synthetic */ void trackOrderCompletedEvent$default(Ometria ometria, String string, OmetriaBasket ometriaBasket, int n, Object object) {
        if ((n & 2) != 0) {
            ometriaBasket = null;
        }
        ometria.trackOrderCompletedEvent(string, ometriaBasket);
    }

    public final void trackHomeScreenViewedEvent() {
        Ometria.trackEvent$default(this, OmetriaEventType.HOME_SCREEN_VIEWED, null, 2, null);
    }

    public final void trackPushTokenRefreshedEvent$OmetriaSDK_release(@Nullable String pushToken) {
        boolean hasPermission;
        OmetriaConfig ometriaConfig = this.ometriaConfig;
        if (ometriaConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ometriaConfig");
            ometriaConfig = null;
        }
        String permissionValue = (hasPermission = NotificationManagerCompat.from((Context)ometriaConfig.getApplication()).areNotificationsEnabled()) ? "opt-in" : "opt-out";
        Pair[] pairArray = new Pair[2];
        String string = pushToken;
        if (string == null) {
            string = "";
        }
        pairArray[0] = TuplesKt.to((Object)"pushToken", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"notifications", (Object)permissionValue);
        this.trackEvent(OmetriaEventType.PUSH_TOKEN_REFRESHED, MapsKt.mapOf((Pair[])pairArray));
    }

    public final void trackNotificationReceivedEvent$OmetriaSDK_release(@NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.trackEvent(OmetriaEventType.NOTIFICATION_RECEIVED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"context", context)));
    }

    public final void trackNotificationInteractedEvent$OmetriaSDK_release(@NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.trackEvent(OmetriaEventType.NOTIFICATION_INTERACTED, MapsKt.mapOf((Pair)TuplesKt.to((Object)"context", context)));
    }

    public final void trackPermissionsUpdateEvent$OmetriaSDK_release(boolean hasPermission) {
        String permissionValue = hasPermission ? "opt-in" : "opt-out";
        this.trackEvent(OmetriaEventType.PERMISSION_UPDATE, MapsKt.mapOf((Pair)TuplesKt.to((Object)"notifications", (Object)permissionValue)));
    }

    public final void trackDeepLinkOpenedEvent(@Nullable String link, @NotNull String page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Pair[] pairArray = new Pair[2];
        String string = link;
        if (string == null) {
            string = "";
        }
        pairArray[0] = TuplesKt.to((Object)"link", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"page", (Object)page);
        this.trackEvent(OmetriaEventType.DEEP_LINK_OPENED, MapsKt.mapOf((Pair[])pairArray));
    }

    public final void trackErrorOccurredEvent$OmetriaSDK_release(@NotNull String errorClass, @Nullable String errorMessage, @NotNull Map<String, ? extends Object> originalMessage) {
        Intrinsics.checkNotNullParameter((Object)errorClass, (String)"errorClass");
        Intrinsics.checkNotNullParameter(originalMessage, (String)"originalMessage");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"class", (Object)errorClass);
        String string = errorMessage;
        if (string == null) {
            string = "";
        }
        pairArray[1] = TuplesKt.to((Object)"message", (Object)string);
        pairArray[2] = TuplesKt.to((Object)"originalMessage", originalMessage);
        this.trackEvent(OmetriaEventType.ERROR_OCCURRED, MapsKt.mapOf((Pair[])pairArray));
    }

    public final void trackCustomEvent(@NotNull String customEventType, @NotNull Map<String, ? extends Object> additionalInfo) {
        Intrinsics.checkNotNullParameter((Object)customEventType, (String)"customEventType");
        Intrinsics.checkNotNullParameter(additionalInfo, (String)"additionalInfo");
        Map data = new LinkedHashMap();
        data.put("properties", additionalInfo);
        data.put("customEventType", customEventType);
        this.trackEvent(OmetriaEventType.CUSTOM, data);
    }

    public static /* synthetic */ void trackCustomEvent$default(Ometria ometria, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        ometria.trackCustomEvent(string, map);
    }

    public final void flush() {
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventHandler");
            eventHandler = null;
        }
        eventHandler.flushEvents();
    }

    public final void clear() {
        LocalCache localCache = this.localCache;
        if (localCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
            localCache = null;
        }
        localCache.clearEvents();
    }

    public final void processAppLink(@NotNull String url, @NotNull ProcessAppLinkListener listener) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        repository.getRedirectForUrl(url, listener);
    }

    @Nullable
    public final OmetriaNotification parseNotification(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        return DeserializationExtensionsKt.toOmetriaNotification(remoteMessage);
    }

    @Override
    public void onNotificationInteraction(@NotNull OmetriaNotification ometriaNotification) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)ometriaNotification, (String)"ometriaNotification");
            String string = ometriaNotification.getDeepLinkActionUrl();
            if (string == null) break block2;
            String safeDeeplinkActionUrl = string;
            boolean bl = false;
            if (!URLUtil.isValidUrl((String)safeDeeplinkActionUrl)) {
                Logger.INSTANCE.e("PushNotifications", "Can not open " + safeDeeplinkActionUrl);
                return;
            }
            Logger.INSTANCE.d("PushNotifications", "Open URL: " + safeDeeplinkActionUrl);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setData(Uri.parse((String)safeDeeplinkActionUrl));
            OmetriaConfig ometriaConfig = this.ometriaConfig;
            if (ometriaConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ometriaConfig");
                ometriaConfig = null;
            }
            ometriaConfig.getApplication().startActivity(intent);
            this.trackDeepLinkOpenedEvent(safeDeeplinkActionUrl, "Browser");
        }
    }

    @Override
    @Deprecated(message="Use the new onNotificationInteraction(ometriaNotification: OmetriaNotification) method")
    public void onDeepLinkInteraction(@NotNull String deepLink) {
        OmetriaNotificationInteractionHandler.DefaultImpls.onDeepLinkInteraction(this, deepLink);
    }

    private static final void retrieveFirebaseToken$lambda$0(Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!task.isSuccessful()) {
            Logger.INSTANCE.w("Events", "Fetching FCM registration token failed.");
            return;
        }
        String token = (String)task.getResult();
        Logger.INSTANCE.d("PushNotifications", "Token - " + token);
        Ometria ometria = Ometria.Companion.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"token");
        ometria.onNewToken(token);
    }

    @JvmStatic
    @NotNull
    public static final Ometria initialize(@NotNull Application application, @NotNull String apiToken, int notificationIcon, @Nullable Integer notificationColor, @NotNull String notificationChannelName) {
        return Companion.initialize(application, apiToken, notificationIcon, notificationColor, notificationChannelName);
    }

    @JvmStatic
    @NotNull
    public static final Ometria instance() {
        return Companion.instance();
    }

    public /* synthetic */ Ometria(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\nH\u0002J;\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u0003\u001a\u00020\u0004H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/android/ometriasdk/core/Ometria$Companion;", "", "()V", "instance", "Lcom/android/ometriasdk/core/Ometria;", "getInstance", "()Lcom/android/ometriasdk/core/Ometria;", "instance$delegate", "Lkotlin/Lazy;", "clearOldInstance", "", "clearOldInstance$OmetriaSDK_release", "clearOldInstanceIfNeeded", "initialize", "application", "Landroid/app/Application;", "apiToken", "", "notificationIcon", "", "notificationColor", "notificationChannelName", "(Landroid/app/Application;Ljava/lang/String;ILjava/lang/Integer;Ljava/lang/String;)Lcom/android/ometriasdk/core/Ometria;", "initializeForInternalUsage", "context", "Landroid/content/Context;", "initializeForInternalUsage$OmetriaSDK_release", "OmetriaSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Ometria getInstance() {
            Lazy lazy = instance$delegate;
            return (Ometria)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final Ometria initialize(@NotNull Application application, @NotNull String apiToken, int notificationIcon, @Nullable Integer notificationColor, @NotNull String notificationChannelName) {
            LocalCache localCache;
            CharSequence charSequence;
            LocalCache localCache2;
            OmetriaThreadPoolExecutor ometriaThreadPoolExecutor;
            Ometria ometria;
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
            Intrinsics.checkNotNullParameter((Object)notificationChannelName, (String)"notificationChannelName");
            Ometria it = ometria = this.getInstance();
            boolean bl = false;
            Companion.clearOldInstanceIfNeeded();
            it.ometriaConfig = new OmetriaConfig(apiToken, (Context)application);
            it.localCache = new LocalCache((Context)application);
            it.executor = new OmetriaThreadPoolExecutor();
            OmetriaConfig ometriaConfig = it.ometriaConfig;
            if (ometriaConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ometriaConfig");
                ometriaConfig = null;
            }
            Client client = new Client(new ConnectionFactory(ometriaConfig));
            LocalCache localCache3 = it.localCache;
            if (localCache3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
                localCache3 = null;
            }
            if ((ometriaThreadPoolExecutor = it.executor) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                ometriaThreadPoolExecutor = null;
            }
            it.repository = new Repository(client, localCache3, ometriaThreadPoolExecutor);
            Context context = (Context)application;
            Repository repository = it.repository;
            if (repository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository = null;
            }
            it.eventHandler = new EventHandler(context, repository);
            Context context2 = (Context)application;
            OmetriaThreadPoolExecutor ometriaThreadPoolExecutor2 = it.executor;
            if (ometriaThreadPoolExecutor2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                ometriaThreadPoolExecutor2 = null;
            }
            it.notificationHandler = new NotificationHandler(context2, notificationIcon, notificationColor, notificationChannelName, ometriaThreadPoolExecutor2);
            it.setNotificationInteractionHandler(Companion.getInstance());
            if (it.shouldGenerateInstallationId()) {
                it.generateInstallationId$OmetriaSDK_release();
            }
            it.isInitialized = true;
            if (it.activityLifecycleHelper != null) {
                OmetriaActivityLifecycleHelper ometriaActivityLifecycleHelper = it.activityLifecycleHelper;
                if (ometriaActivityLifecycleHelper != null) {
                    Repository repository2 = it.repository;
                    if (repository2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                        repository2 = null;
                    }
                    ometriaActivityLifecycleHelper.setRepository(repository2);
                }
            } else {
                Repository repository3 = it.repository;
                if (repository3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                    repository3 = null;
                }
                it.activityLifecycleHelper = new OmetriaActivityLifecycleHelper(repository3, (Context)application);
                OmetriaActivityLifecycleHelper ometriaActivityLifecycleHelper = it.activityLifecycleHelper;
                if (ometriaActivityLifecycleHelper != null) {
                    OmetriaActivityLifecycleHelper activityLifecycleHelper = ometriaActivityLifecycleHelper;
                    boolean bl2 = false;
                    ProcessLifecycleOwner.Companion.get().getLifecycle().addObserver((LifecycleObserver)activityLifecycleHelper);
                }
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)it.activityLifecycleHelper);
            }
            if ((localCache2 = it.localCache) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
                localCache2 = null;
            }
            if ((charSequence = (CharSequence)localCache2.getPushToken()) == null || charSequence.length() == 0) {
                it.retrieveFirebaseToken();
            }
            if ((localCache = it.localCache) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
                localCache = null;
            }
            localCache.saveApiToken(apiToken);
            return ometria;
        }

        public static /* synthetic */ Ometria initialize$default(Companion companion, Application application, String string, int n, Integer n2, String string2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x10) != 0) {
                string2 = " ";
            }
            return companion.initialize(application, string, n, n2, string2);
        }

        @NotNull
        public final Ometria initializeForInternalUsage$OmetriaSDK_release(@NotNull Context context) {
            String apiToken;
            Ometria ometria;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Ometria it = ometria = this.getInstance();
            boolean bl = false;
            it.executor = new OmetriaThreadPoolExecutor();
            it.localCache = new LocalCache(context);
            LocalCache localCache = it.localCache;
            if (localCache == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
                localCache = null;
            }
            if ((apiToken = localCache.getApiToken()) != null) {
                OmetriaThreadPoolExecutor ometriaThreadPoolExecutor;
                it.ometriaConfig = new OmetriaConfig(apiToken, context);
                OmetriaConfig ometriaConfig = it.ometriaConfig;
                if (ometriaConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ometriaConfig");
                    ometriaConfig = null;
                }
                Client client = new Client(new ConnectionFactory(ometriaConfig));
                LocalCache localCache2 = it.localCache;
                if (localCache2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localCache");
                    localCache2 = null;
                }
                if ((ometriaThreadPoolExecutor = it.executor) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                    ometriaThreadPoolExecutor = null;
                }
                it.repository = new Repository(client, localCache2, ometriaThreadPoolExecutor);
                Repository repository = it.repository;
                if (repository == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                    repository = null;
                }
                it.eventHandler = new EventHandler(context, repository);
                it.isInitialized = true;
            }
            return ometria;
        }

        private final void clearOldInstanceIfNeeded() {
            if (this.getInstance().isInitialized) {
                this.clearOldInstance$OmetriaSDK_release();
            }
        }

        public final void clearOldInstance$OmetriaSDK_release() {
            this.getInstance().flush();
            this.getInstance().clear();
            this.getInstance().isInitialized = false;
        }

        @JvmStatic
        @NotNull
        public final Ometria instance() {
            if (!this.getInstance().isInitialized) {
                throw new IllegalStateException("SDK not initialized. Please initialize before using this method.");
            }
            return this.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\n\n\u0002\b\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/ometriasdk/core/Ometria$HOLDER;", "", "()V", "INSTANCE", "Lcom/android/ometriasdk/core/Ometria;", "getINSTANCE", "()Lcom/android/ometriasdk/core/Ometria;", "INSTANCE$1", "OmetriaSDK_release"})
    private static final class HOLDER {
        @NotNull
        public static final HOLDER INSTANCE = new HOLDER();
        @NotNull
        private static final Ometria INSTANCE$1 = new Ometria(null);

        private HOLDER() {
        }

        @NotNull
        public final Ometria getINSTANCE() {
            return INSTANCE$1;
        }
    }
}

