/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core;

import android.os.Handler;
import android.os.Looper;
import com.android.ometriasdk.core.LocalCache;
import com.android.ometriasdk.core.Logger;
import com.android.ometriasdk.core.event.EventExtensionsKt;
import com.android.ometriasdk.core.event.OmetriaEvent;
import com.android.ometriasdk.core.listener.ProcessAppLinkListener;
import com.android.ometriasdk.core.network.Client;
import com.android.ometriasdk.core.network.OmetriaThreadPoolExecutor;
import com.android.ometriasdk.core.network.model.OmetriaApiError;
import com.android.ometriasdk.core.network.model.OmetriaApiRequest;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u0004\u0018\u00010\u0019J\u0006\u0010#\u001a\u00020\u000eJ\u0006\u0010$\u001a\u00020\u000eJ,\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\u0018\u0010(\u001a\u00020\u00102\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0019J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0014J\u000e\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0019J\u000e\u00102\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000eJ\u000e\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u0019J \u00105\u001a\u00020\u00102\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u00106\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/ometriasdk/core/Repository;", "", "client", "Lcom/android/ometriasdk/core/network/Client;", "localCache", "Lcom/android/ometriasdk/core/LocalCache;", "executor", "Lcom/android/ometriasdk/core/network/OmetriaThreadPoolExecutor;", "(Lcom/android/ometriasdk/core/network/Client;Lcom/android/ometriasdk/core/LocalCache;Lcom/android/ometriasdk/core/network/OmetriaThreadPoolExecutor;)V", "dropStatusCodesRange", "Lkotlin/ranges/IntRange;", "resultHandler", "Landroid/os/Handler;", "areNotificationsEnabled", "", "clearProfileIdentifiedData", "", "flushEvents", "events", "", "Lcom/android/ometriasdk/core/event/OmetriaEvent;", "success", "Lkotlin/Function0;", "error", "getCustomerId", "", "getEmail", "getEvents", "getInstallationId", "getPushToken", "getRedirectForUrl", "url", "listener", "Lcom/android/ometriasdk/core/listener/ProcessAppLinkListener;", "getSdkVersionRN", "isFirstAppRun", "isFirstPermissionsUpdateEvent", "postEvents", "apiRequest", "Lcom/android/ometriasdk/core/network/model/OmetriaApiRequest;", "removeEvents", "saveAreNotificationsEnabled", "saveCustomerId", "customerId", "saveEmail", "email", "saveEvent", "ometriaEvent", "saveInstallationId", "installationId", "saveIsFirstAppRun", "savePushToken", "pushToken", "updateEvents", "isBeingFlushed", "OmetriaSDK_release"})
@SourceDebugExtension(value={"SMAP\nRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Repository.kt\ncom/android/ometriasdk/core/Repository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n*S KotlinDebug\n*F\n+ 1 Repository.kt\ncom/android/ometriasdk/core/Repository\n*L\n29#1:151,2\n*E\n"})
public final class Repository {
    @NotNull
    private final Client client;
    @NotNull
    private final LocalCache localCache;
    @NotNull
    private final OmetriaThreadPoolExecutor executor;
    @NotNull
    private final Handler resultHandler;
    @NotNull
    private final IntRange dropStatusCodesRange;

    public Repository(@NotNull Client client, @NotNull LocalCache localCache, @NotNull OmetriaThreadPoolExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)localCache, (String)"localCache");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.client = client;
        this.localCache = localCache;
        this.executor = executor;
        this.resultHandler = new Handler(Looper.getMainLooper());
        this.dropStatusCodesRange = new IntRange(400, 499);
    }

    public final void flushEvents(@NotNull List<OmetriaEvent> events, @NotNull Function0<Unit> success, @NotNull Function0<Unit> error) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(success, (String)"success");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OmetriaEvent it = (OmetriaEvent)element$iv;
            boolean bl = false;
            it.setBeingFlushed(true);
        }
        OmetriaApiRequest apiRequest = EventExtensionsKt.toApiRequest(events);
        this.updateEvents(events, true);
        this.postEvents(apiRequest, success, error);
    }

    private final void postEvents(OmetriaApiRequest apiRequest, Function0<Unit> success, Function0<Unit> error) {
        this.executor.execute(() -> Repository.postEvents$lambda$1(this, apiRequest, error, success));
    }

    public final void saveIsFirstAppRun(boolean isFirstAppRun) {
        this.localCache.saveIsFirstAppRun(isFirstAppRun);
    }

    public final boolean isFirstAppRun() {
        return this.localCache.isFirstAppRun();
    }

    public final void saveInstallationId(@NotNull String installationId) {
        Intrinsics.checkNotNullParameter((Object)installationId, (String)"installationId");
        this.localCache.saveInstallationId(installationId);
    }

    @Nullable
    public final String getInstallationId() {
        return this.localCache.getInstallationId();
    }

    public final void saveEvent(@NotNull OmetriaEvent ometriaEvent) {
        Intrinsics.checkNotNullParameter((Object)ometriaEvent, (String)"ometriaEvent");
        this.localCache.saveEvent(ometriaEvent);
    }

    @NotNull
    public final List<OmetriaEvent> getEvents() {
        return this.localCache.getEvents();
    }

    private final void updateEvents(List<OmetriaEvent> events, boolean isBeingFlushed) {
        this.localCache.updateEvents(events, isBeingFlushed);
    }

    private final void removeEvents(List<OmetriaEvent> events) {
        if (events == null) {
            return;
        }
        this.localCache.removeEvents(events);
    }

    public final void savePushToken(@NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        this.localCache.savePushToken(pushToken);
    }

    @Nullable
    public final String getPushToken() {
        return this.localCache.getPushToken();
    }

    public final void saveCustomerId(@NotNull String customerId) {
        Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
        this.localCache.saveCustomerId(customerId);
    }

    @Nullable
    public final String getCustomerId() {
        return this.localCache.getCustomerId();
    }

    public final void saveEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.localCache.saveEmail(email);
    }

    @Nullable
    public final String getEmail() {
        return this.localCache.getEmail();
    }

    public final void clearProfileIdentifiedData() {
        this.localCache.clearProfileIdentifiedData();
    }

    public final void saveAreNotificationsEnabled(boolean areNotificationsEnabled) {
        this.localCache.saveAreNotificationsEnabled(areNotificationsEnabled);
        this.localCache.saveIsFirstPermissionsUpdateEvent(false);
    }

    public final boolean areNotificationsEnabled() {
        return this.localCache.areNotificationsEnabled();
    }

    public final boolean isFirstPermissionsUpdateEvent() {
        return this.localCache.isFirstPermissionsUpdateEvent();
    }

    public final void getRedirectForUrl(@NotNull String url, @NotNull ProcessAppLinkListener listener) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.executor.execute(() -> Repository.getRedirectForUrl$lambda$6(url, this, listener));
    }

    @Nullable
    public final String getSdkVersionRN() {
        return this.localCache.getSdkVersionRN();
    }

    private static final void postEvents$lambda$1(Repository this$0, OmetriaApiRequest $apiRequest, Function0 $error, Function0 $success) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$apiRequest, (String)"$apiRequest");
        Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
        Intrinsics.checkNotNullParameter((Object)$success, (String)"$success");
        try {
            this$0.client.postEvents($apiRequest, (Function0<Unit>)((Function0)new Function0<Unit>((Function0<Unit>)$success, this$0, $apiRequest){
                final /* synthetic */ Function0<Unit> $success;
                final /* synthetic */ Repository this$0;
                final /* synthetic */ OmetriaApiRequest $apiRequest;
                {
                    this.$success = $success;
                    this.this$0 = $receiver;
                    this.$apiRequest = $apiRequest;
                    super(0);
                }

                public final void invoke() {
                    this.$success.invoke();
                    Repository.access$removeEvents(this.this$0, this.$apiRequest.getEvents());
                }
            }), (Function1<? super OmetriaApiError, Unit>)((Function1)new Function1<OmetriaApiError, Unit>((Function0<Unit>)$error, this$0, $apiRequest){
                final /* synthetic */ Function0<Unit> $error;
                final /* synthetic */ Repository this$0;
                final /* synthetic */ OmetriaApiRequest $apiRequest;
                {
                    this.$error = $error;
                    this.this$0 = $receiver;
                    this.$apiRequest = $apiRequest;
                    super(1);
                }

                public final void invoke(@NotNull OmetriaApiError it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.getDetail();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    Logger.INSTANCE.e("Network", string);
                    this.$error.invoke();
                    if (CollectionsKt.contains((Iterable)CollectionsKt.minus((Iterable)((Iterable)Repository.access$getDropStatusCodesRange$p(this.this$0)), (Object)429), (Object)it.getStatus())) {
                        Repository.access$removeEvents(this.this$0, this.$apiRequest.getEvents());
                    } else {
                        Repository.access$updateEvents(this.this$0, this.$apiRequest.getEvents(), false);
                    }
                }
            }));
        }
        catch (IOException e) {
            Logger.INSTANCE.e("Network", e.getMessage(), e);
            $error.invoke();
        }
    }

    private static final void getRedirectForUrl$lambda$6$lambda$2(ProcessAppLinkListener $listener, MalformedURLException $e) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getMessage();
        if (string == null) {
            string = "Something went wrong";
        }
        $listener.onProcessFailed(string);
    }

    private static final void getRedirectForUrl$lambda$6$lambda$3(ProcessAppLinkListener $listener, IOException $e) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getMessage();
        if (string == null) {
            string = "Something went wrong";
        }
        $listener.onProcessFailed(string);
    }

    private static final void getRedirectForUrl$lambda$6$lambda$4(ProcessAppLinkListener $listener, IOException $e) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getMessage();
        if (string == null) {
            string = "Something went wrong";
        }
        $listener.onProcessFailed(string);
    }

    private static final void getRedirectForUrl$lambda$6$lambda$5(ProcessAppLinkListener $listener, HttpURLConnection $connection) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        HttpURLConnection httpURLConnection = $connection;
        $listener.onProcessResult(String.valueOf(httpURLConnection != null ? httpURLConnection.getURL() : null));
    }

    private static final void getRedirectForUrl$lambda$6(String $url, Repository this$0, ProcessAppLinkListener $listener) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            URL urlTemp = null;
            HttpURLConnection connection = null;
            try {
                urlTemp = new URL($url);
            }
            catch (MalformedURLException e) {
                this$0.resultHandler.post(() -> Repository.getRedirectForUrl$lambda$6$lambda$2($listener, e));
                return;
            }
            try {
                URLConnection e = urlTemp.openConnection();
                connection = e instanceof HttpURLConnection ? (HttpURLConnection)e : null;
            }
            catch (IOException e) {
                this$0.resultHandler.post(() -> Repository.getRedirectForUrl$lambda$6$lambda$3($listener, e));
                return;
            }
            try {
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection != null) {
                    httpURLConnection.getResponseCode();
                }
            }
            catch (IOException e) {
                this$0.resultHandler.post(() -> Repository.getRedirectForUrl$lambda$6$lambda$4($listener, e));
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return;
            }
            this$0.resultHandler.post(() -> Repository.getRedirectForUrl$lambda$6$lambda$5($listener, connection));
            HttpURLConnection httpURLConnection = connection;
            if (httpURLConnection == null) break block8;
            httpURLConnection.disconnect();
        }
    }

    public static final /* synthetic */ void access$removeEvents(Repository $this, List events) {
        $this.removeEvents(events);
    }

    public static final /* synthetic */ IntRange access$getDropStatusCodesRange$p(Repository $this) {
        return $this.dropStatusCodesRange;
    }

    public static final /* synthetic */ void access$updateEvents(Repository $this, List events, boolean isBeingFlushed) {
        $this.updateEvents(events, isBeingFlushed);
    }
}

