/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core.event;

import android.content.Context;
import android.content.pm.PackageInfo;
import androidx.core.content.pm.PackageInfoCompat;
import com.android.ometriasdk.core.Logger;
import com.android.ometriasdk.core.Ometria;
import com.android.ometriasdk.core.Repository;
import com.android.ometriasdk.core.event.EventExtensionsKt;
import com.android.ometriasdk.core.event.OmetriaEvent;
import com.android.ometriasdk.core.event.OmetriaEventType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010\u0017\u001a\u00020\u0011H\u0002J&\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/ometriasdk/core/event/EventHandler;", "", "context", "Landroid/content/Context;", "repository", "Lcom/android/ometriasdk/core/Repository;", "(Landroid/content/Context;Lcom/android/ometriasdk/core/Repository;)V", "appId", "", "kotlin.jvm.PlatformType", "dateFormat", "Ljava/text/DateFormat;", "packageInfo", "Landroid/content/pm/PackageInfo;", "syncTimestamp", "", "cacheProfileIdentifiedData", "", "data", "", "canFlush", "", "flushEvents", "flushEventsIfNeeded", "processEvent", "type", "Lcom/android/ometriasdk/core/event/OmetriaEventType;", "", "sendEvent", "ometriaEvent", "Lcom/android/ometriasdk/core/event/OmetriaEvent;", "shouldFlush", "OmetriaSDK_release"})
@SourceDebugExtension(value={"SMAP\nEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventHandler.kt\ncom/android/ometriasdk/core/event/EventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,156:1\n766#2:157\n857#2,2:158\n1477#2:160\n1502#2,3:161\n1505#2,3:171\n1855#2,2:175\n766#2:178\n857#2,2:179\n361#3,7:164\n215#4:174\n216#4:177\n*S KotlinDebug\n*F\n+ 1 EventHandler.kt\ncom/android/ometriasdk/core/event/EventHandler\n*L\n113#1:157\n113#1:158,2\n115#1:160\n115#1:161,3\n115#1:171,3\n118#1:175,2\n155#1:178\n155#1:179,2\n115#1:164,7\n115#1:174\n115#1:177\n*E\n"})
public final class EventHandler {
    @NotNull
    private final Repository repository;
    @NotNull
    private final DateFormat dateFormat;
    private final String appId;
    private final PackageInfo packageInfo;
    private long syncTimestamp;

    public EventHandler(@NotNull Context context, @NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ", Locale.UK);
        this.appId = context.getPackageName();
        this.packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        this.syncTimestamp = -1L;
    }

    public final void processEvent(@NotNull OmetriaEventType type, @Nullable Map<String, Object> data) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String installationId = this.repository.getInstallationId();
        String appVersion = this.packageInfo.versionName;
        String appBuildNumber = String.valueOf(PackageInfoCompat.getLongVersionCode((PackageInfo)this.packageInfo));
        if (type == OmetriaEventType.PUSH_TOKEN_REFRESHED) {
            Map<String, Object> map = data;
            if (map != null) {
                String customerId;
                Map<String, Object> it = map;
                boolean bl = false;
                Object object = it.get("pushToken");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.repository.savePushToken((String)object);
                String string = this.repository.getCustomerId();
                if (string != null) {
                    customerId = string;
                    boolean bl2 = false;
                    data.put("customerId", customerId);
                }
                String string2 = this.repository.getEmail();
                if (string2 != null) {
                    customerId = string2;
                    boolean bl3 = false;
                    data.put("email", customerId);
                }
            }
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String string3 = this.dateFormat.format(Calendar.getInstance().getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dateFormat.format(Calendar.getInstance().time)");
        OmetriaEvent event = new OmetriaEvent(string, false, string3, this.appId, installationId, appVersion, appBuildNumber, null, null, null, null, null, type.getId(), data, this.repository.getSdkVersionRN(), 3970, null);
        this.sendEvent(event);
        String string4 = event.getType();
        if (Intrinsics.areEqual((Object)string4, (Object)OmetriaEventType.PROFILE_IDENTIFIED.getId())) {
            this.cacheProfileIdentifiedData(data);
            Ometria.Companion.instance().trackPushTokenRefreshedEvent$OmetriaSDK_release(this.repository.getPushToken());
        } else if (Intrinsics.areEqual((Object)string4, (Object)OmetriaEventType.PROFILE_DEIDENTIFIED.getId())) {
            this.repository.clearProfileIdentifiedData();
        }
    }

    public static /* synthetic */ void processEvent$default(EventHandler eventHandler, OmetriaEventType ometriaEventType, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        eventHandler.processEvent(ometriaEventType, map);
    }

    private final void cacheProfileIdentifiedData(Map<String, ? extends Object> data) {
        block2: {
            Map<String, ? extends Object> map = data;
            if (map == null) break block2;
            Map<String, ? extends Object> it = map;
            boolean bl = false;
            if (it.get("customerId") != null) {
                Object object = it.get("customerId");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.repository.saveCustomerId((String)object);
            } else {
                Object object = it.get("email");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.repository.saveEmail((String)object);
            }
        }
    }

    private final void sendEvent(OmetriaEvent ometriaEvent) {
        Logger.INSTANCE.d("Events", "Track event - ", ometriaEvent);
        this.repository.saveEvent(ometriaEvent);
        String string = ometriaEvent.getType();
        if (((Intrinsics.areEqual((Object)string, (Object)OmetriaEventType.PUSH_TOKEN_REFRESHED.getId()) ? true : Intrinsics.areEqual((Object)string, (Object)OmetriaEventType.APP_FOREGROUNDED.getId())) ? true : Intrinsics.areEqual((Object)string, (Object)OmetriaEventType.APP_BACKGROUNDED.getId())) ? true : Intrinsics.areEqual((Object)string, (Object)OmetriaEventType.NOTIFICATION_RECEIVED.getId())) {
            this.flushEvents();
        } else {
            this.flushEventsIfNeeded();
        }
    }

    private final void flushEventsIfNeeded() {
        if (this.shouldFlush() && this.canFlush()) {
            this.syncTimestamp = System.currentTimeMillis();
            this.flushEvents();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void flushEvents() {
        void $this$groupByTo$iv$iv;
        OmetriaEvent it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.repository.getEvents();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OmetriaEvent)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBeingFlushed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List events = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = events;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (OmetriaEvent)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = EventExtensionsKt.batchIdentifier(it);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$forEach$iv2;
            Map.Entry element$iv;
            Object element$iv$iv;
            Map.Entry group = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            element$iv$iv = CollectionsKt.chunked((Iterable)((Iterable)group.getValue()), (int)100);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List it2 = (List)element$iv2;
                boolean bl3 = false;
                this.repository.flushEvents(it2, (Function0<Unit>)((Function0)new Function0<Unit>((List<OmetriaEvent>)it2){
                    final /* synthetic */ List<OmetriaEvent> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        Logger.INSTANCE.d("Events", "Successfully flushed " + this.$it.size() + " events");
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>((List<OmetriaEvent>)it2){
                    final /* synthetic */ List<OmetriaEvent> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        Logger.INSTANCE.d("Events", "Failed to flush " + this.$it.size() + " events");
                    }
                }));
            }
        }
    }

    private final boolean canFlush() {
        boolean bl;
        boolean it = bl = System.currentTimeMillis() >= this.syncTimestamp + TimeUnit.SECONDS.toMillis(10L);
        boolean bl2 = false;
        if (!it) {
            Logger.INSTANCE.d("Network", "Attempted to flush events but not enough time has passed since the last flush.");
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldFlush() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.repository.getEvents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OmetriaEvent it = (OmetriaEvent)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBeingFlushed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size() >= 10;
    }
}

