/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core.network;

import com.android.ometriasdk.core.Logger;
import com.android.ometriasdk.core.network.ConnectionFactory;
import com.android.ometriasdk.core.network.DeserializationExtensionsKt;
import com.android.ometriasdk.core.network.SerializationExtensionsKt;
import com.android.ometriasdk.core.network.model.OmetriaApiError;
import com.android.ometriasdk.core.network.model.OmetriaApiRequest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/ometriasdk/core/network/Client;", "", "connectionFactory", "Lcom/android/ometriasdk/core/network/ConnectionFactory;", "(Lcom/android/ometriasdk/core/network/ConnectionFactory;)V", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "postEvents", "", "ometriaApiRequest", "Lcom/android/ometriasdk/core/network/model/OmetriaApiRequest;", "success", "Lkotlin/Function0;", "error", "Lkotlin/Function1;", "Lcom/android/ometriasdk/core/network/model/OmetriaApiError;", "OmetriaSDK_release"})
public final class Client {
    @NotNull
    private final ConnectionFactory connectionFactory;
    private final Charset UTF8;

    public Client(@NotNull ConnectionFactory connectionFactory) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        this.connectionFactory = connectionFactory;
        this.UTF8 = Charset.forName("UTF-8");
    }

    public final void postEvents(@NotNull OmetriaApiRequest ometriaApiRequest, @NotNull Function0<Unit> success, @NotNull Function1<? super OmetriaApiError, Unit> error) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ometriaApiRequest, (String)"ometriaApiRequest");
        Intrinsics.checkNotNullParameter(success, (String)"success");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        HttpURLConnection connection = this.connectionFactory.postConnection();
        OutputStream outputStream = connection.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"connection.outputStream");
        OutputStream os = outputStream;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.UTF8));
        writer.write(SerializationExtensionsKt.toJson(ometriaApiRequest).toString());
        writer.flush();
        writer.close();
        os.close();
        int responseCode = connection.getResponseCode();
        boolean bl = 200 <= responseCode ? responseCode < 300 : false;
        if (bl) {
            success.invoke();
        } else if (responseCode >= 300) {
            String body = TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(connection.getErrorStream())));
            try {
                error.invoke((Object)DeserializationExtensionsKt.toOmetriaApiError(body));
            }
            catch (JSONException e) {
                Logger.INSTANCE.e("Network", e.getMessage(), e);
            }
        }
    }
}

