/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core.network;

import com.android.ometriasdk.core.OmetriaConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/ometriasdk/core/network/ConnectionFactory;", "", "ometriaConfig", "Lcom/android/ometriasdk/core/OmetriaConfig;", "(Lcom/android/ometriasdk/core/OmetriaConfig;)V", "timeout", "", "postConnection", "Ljava/net/HttpURLConnection;", "OmetriaSDK_release"})
public final class ConnectionFactory {
    @NotNull
    private final OmetriaConfig ometriaConfig;
    private final int timeout;

    public ConnectionFactory(@NotNull OmetriaConfig ometriaConfig) {
        Intrinsics.checkNotNullParameter((Object)ometriaConfig, (String)"ometriaConfig");
        this.ometriaConfig = ometriaConfig;
        this.timeout = (int)TimeUnit.SECONDS.toMillis(30L);
    }

    @NotNull
    public final HttpURLConnection postConnection() {
        URL uRL;
        String url = "https://mobile-events.ometria.com/v1/mobile-events";
        try {
            uRL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IOException("Attempted to use malformed url: " + url, e);
        }
        URL requestedURL = uRL;
        URLConnection uRLConnection = requestedURL.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("X-Ometria-Auth", this.ometriaConfig.getApiToken());
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setChunkedStreamingMode(0);
        return connection;
    }
}

