/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.core.network;

import com.android.ometriasdk.core.Logger;
import com.android.ometriasdk.core.Ometria;
import com.android.ometriasdk.core.event.OmetriaEvent;
import com.android.ometriasdk.core.network.model.OmetriaApiError;
import com.android.ometriasdk.notification.OmetriaNotification;
import com.android.ometriasdk.notification.OmetriaNotificationBody;
import com.google.firebase.messaging.RemoteMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u0004\u0018\u00010\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0000\u001a\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n*\u00020\u0002H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u000eH\u0000\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\r*\u00020\u0002H\u0000\u00a8\u0006\u0010"}, d2={"toMap", "", "", "", "Lorg/json/JSONObject;", "toOmetriaApiError", "Lcom/android/ometriasdk/core/network/model/OmetriaApiError;", "toOmetriaEvent", "Lcom/android/ometriasdk/core/event/OmetriaEvent;", "toOmetriaEventList", "", "toOmetriaNotification", "Lcom/android/ometriasdk/notification/OmetriaNotification;", "Lcom/android/ometriasdk/notification/OmetriaNotificationBody;", "Lcom/google/firebase/messaging/RemoteMessage;", "toOmetriaNotificationBody", "OmetriaSDK_release"})
public final class DeserializationExtensionsKt {
    @NotNull
    public static final List<OmetriaEvent> toOmetriaEventList(@NotNull String $this$toOmetriaEventList) {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaEventList, (String)"<this>");
        JSONArray jsonArray = new JSONArray($this$toOmetriaEventList);
        List ometriaEventArray = new ArrayList();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            ometriaEventArray.add(DeserializationExtensionsKt.toOmetriaEvent(jsonArray.get(i).toString()));
        }
        return ometriaEventArray;
    }

    @NotNull
    public static final OmetriaEvent toOmetriaEvent(@NotNull String $this$toOmetriaEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaEvent, (String)"<this>");
        JSONObject jsonObject = new JSONObject($this$toOmetriaEvent);
        String string = jsonObject.getString("eventId");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(\"eventId\")");
        boolean bl = jsonObject.getBoolean("isBeingFlushed");
        String string2 = jsonObject.getString("dtOccurred");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(\"dtOccurred\")");
        String string3 = jsonObject.getString("appId");
        String string4 = jsonObject.getString("installationId");
        String string5 = jsonObject.getString("appVersion");
        String string6 = jsonObject.getString("appBuildNumber");
        String string7 = jsonObject.getString("sdkVersion");
        String string8 = jsonObject.getString("platform");
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"jsonObject.getString(\"platform\")");
        String string9 = jsonObject.getString("osVersion");
        String string10 = jsonObject.getString("deviceManufacturer");
        String string11 = jsonObject.getString("deviceModel");
        String string12 = jsonObject.getString("type");
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"jsonObject.getString(\"type\")");
        OmetriaEvent ometriaEvent = new OmetriaEvent(string, bl, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, DeserializationExtensionsKt.toMap(jsonObject.getJSONObject("data")), null, 16384, null);
        String sdkVersionRN = null;
        try {
            sdkVersionRN = jsonObject.getString("sdkVersionRN");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ometriaEvent.setSdkVersionRN(sdkVersionRN);
        return ometriaEvent;
    }

    @NotNull
    public static final Map<String, Object> toMap(@Nullable JSONObject $this$toMap) {
        if ($this$toMap == null) {
            return MapsKt.emptyMap();
        }
        Map map = new LinkedHashMap();
        Iterator iterator = $this$toMap.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"this.keys()");
        Iterator keysItr = iterator;
        while (keysItr.hasNext()) {
            Map<String, Object> value;
            String key = (String)keysItr.next();
            Intrinsics.checkNotNullExpressionValue((Object)$this$toMap.get(key), (String)"this.get(key)");
            if (value instanceof JSONObject) {
                value = DeserializationExtensionsKt.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @NotNull
    public static final OmetriaApiError toOmetriaApiError(@NotNull String $this$toOmetriaApiError) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaApiError, (String)"<this>");
        JSONObject jsonObject = new JSONObject($this$toOmetriaApiError);
        return new OmetriaApiError(jsonObject.getString("detail"), jsonObject.getInt("status"), jsonObject.getString("title"), jsonObject.getString("type"));
    }

    @NotNull
    public static final OmetriaNotificationBody toOmetriaNotificationBody(@NotNull String $this$toOmetriaNotificationBody) {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaNotificationBody, (String)"<this>");
        JSONObject jsonObject = new JSONObject($this$toOmetriaNotificationBody);
        Map<String, Object> context = null;
        String deepLinkActionUrl = null;
        String imageUrl = null;
        try {
            context = DeserializationExtensionsKt.toMap(jsonObject.getJSONObject("context"));
        }
        catch (JSONException e) {
            Logger.INSTANCE.e("PushNotifications", e.getMessage(), e);
            Ometria ometria = Ometria.Companion.instance();
            String string = ((Object)((Object)e)).getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.javaClass.name");
            ometria.trackErrorOccurredEvent$OmetriaSDK_release(string, e.getMessage(), DeserializationExtensionsKt.toMap(jsonObject));
        }
        try {
            deepLinkActionUrl = jsonObject.getString("deepLinkActionUrl");
        }
        catch (JSONException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            Logger.INSTANCE.w("PushNotifications", string);
        }
        try {
            imageUrl = jsonObject.getString("imageUrl");
        }
        catch (JSONException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            Logger.INSTANCE.w("PushNotifications", string);
        }
        return new OmetriaNotificationBody(imageUrl, deepLinkActionUrl, context);
    }

    @Nullable
    public static final OmetriaNotificationBody toOmetriaNotificationBody(@NotNull RemoteMessage $this$toOmetriaNotificationBody) {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaNotificationBody, (String)"<this>");
        String ometriaNotificationString = (String)$this$toOmetriaNotificationBody.getData().get("ometria");
        if (ometriaNotificationString == null) {
            return null;
        }
        return DeserializationExtensionsKt.toOmetriaNotificationBody(ometriaNotificationString);
    }

    @Nullable
    public static final OmetriaNotification toOmetriaNotification(@NotNull RemoteMessage $this$toOmetriaNotification) {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaNotification, (String)"<this>");
        OmetriaNotificationBody ometriaNotificationBody = DeserializationExtensionsKt.toOmetriaNotificationBody($this$toOmetriaNotification);
        return ometriaNotificationBody != null ? DeserializationExtensionsKt.toOmetriaNotification(ometriaNotificationBody) : null;
    }

    @NotNull
    public static final OmetriaNotification toOmetriaNotification(@NotNull OmetriaNotificationBody $this$toOmetriaNotification) {
        Intrinsics.checkNotNullParameter((Object)$this$toOmetriaNotification, (String)"<this>");
        String deepLinkActionUrl = $this$toOmetriaNotification.getDeepLinkActionUrl();
        String imageUrl = $this$toOmetriaNotification.getImageUrl();
        Map<String, Object> map = $this$toOmetriaNotification.getContext();
        Object object = map != null ? map.get("campaign_type") : null;
        String campaignType = object instanceof String ? (String)object : null;
        Map<String, Object> map2 = $this$toOmetriaNotification.getContext();
        Object object2 = map2 != null ? map2.get("ext_customer_id") : null;
        String externalCustomerId = object2 instanceof String ? (String)object2 : null;
        Map<String, Object> map3 = $this$toOmetriaNotification.getContext();
        Object object3 = map3 != null ? map3.get("send_id") : null;
        String sendId = object3 instanceof String ? (String)object3 : null;
        Map<String, Object> map4 = $this$toOmetriaNotification.getContext();
        Object object4 = map4 != null ? map4.get("tracking") : null;
        Map tracking = object4 instanceof Map ? (Map)object4 : null;
        return new OmetriaNotification(deepLinkActionUrl, imageUrl, campaignType, externalCustomerId, sendId, tracking);
    }
}

