/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.NotificationManagerCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.android.ometriasdk.core.Ometria;
import com.android.ometriasdk.core.Repository;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/ometriasdk/lifecycle/OmetriaActivityLifecycleHelper;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "repository", "Lcom/android/ometriasdk/core/Repository;", "context", "Landroid/content/Context;", "(Lcom/android/ometriasdk/core/Repository;Landroid/content/Context;)V", "firstLaunch", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRepository", "()Lcom/android/ometriasdk/core/Repository;", "setRepository", "(Lcom/android/ometriasdk/core/Repository;)V", "trackedApplicationLifecycleEvents", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onCreate", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStart", "onStop", "trackDeepLink", "OmetriaSDK_release"})
public final class OmetriaActivityLifecycleHelper
implements DefaultLifecycleObserver,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private Repository repository;
    @NotNull
    private final Context context;
    @NotNull
    private final AtomicBoolean firstLaunch;
    @NotNull
    private final AtomicBoolean trackedApplicationLifecycleEvents;

    public OmetriaActivityLifecycleHelper(@NotNull Repository repository, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.repository = repository;
        this.context = context;
        this.firstLaunch = new AtomicBoolean(false);
        this.trackedApplicationLifecycleEvents = new AtomicBoolean(false);
    }

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    public final void setRepository(@NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"<set-?>");
        this.repository = repository;
    }

    public void onCreate(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!this.trackedApplicationLifecycleEvents.getAndSet(true)) {
            this.firstLaunch.set(true);
        }
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (this.repository.isFirstAppRun()) {
            Ometria.Companion.instance().trackAppInstalledEvent$OmetriaSDK_release();
            this.repository.saveIsFirstAppRun(false);
        }
        if (this.firstLaunch.get()) {
            Ometria.Companion.instance().trackAppLaunchedEvent$OmetriaSDK_release();
        }
        Ometria.Companion.instance().trackAppForegroundedEvent$OmetriaSDK_release();
        this.firstLaunch.getAndSet(false);
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Ometria.Companion.instance().trackAppBackgroundedEvent$OmetriaSDK_release();
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.trackDeepLink(activity);
    }

    private final void trackDeepLink(Activity activity) {
        Intent intent = activity.getIntent();
        if (intent == null || intent.getData() == null) {
            return;
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        boolean areNotificationsEnabled = NotificationManagerCompat.from((Context)this.context).areNotificationsEnabled();
        if (areNotificationsEnabled != this.repository.areNotificationsEnabled() || this.repository.isFirstPermissionsUpdateEvent()) {
            this.repository.saveAreNotificationsEnabled(areNotificationsEnabled);
            Ometria.Companion.instance().trackPermissionsUpdateEvent$OmetriaSDK_release(areNotificationsEnabled);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }
}

