/*
 * Decompiled with CFR 0.152.
 */
package com.android.ometriasdk.notification;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.android.ometriasdk.core.Logger;
import com.android.ometriasdk.core.Ometria;
import com.android.ometriasdk.core.network.DeserializationExtensionsKt;
import com.android.ometriasdk.core.network.OmetriaThreadPoolExecutor;
import com.android.ometriasdk.notification.OmetriaNotificationBody;
import com.android.ometriasdk.notification.OmetriaPushNotification;
import com.google.firebase.messaging.RemoteMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0014\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/ometriasdk/notification/NotificationHandler;", "", "context", "Landroid/content/Context;", "notificationIcon", "", "notificationColor", "notificationChannelName", "", "executor", "Lcom/android/ometriasdk/core/network/OmetriaThreadPoolExecutor;", "(Landroid/content/Context;ILjava/lang/Integer;Ljava/lang/String;Lcom/android/ometriasdk/core/network/OmetriaThreadPoolExecutor;)V", "ometriaPushNotification", "Lcom/android/ometriasdk/notification/OmetriaPushNotification;", "handleNotification", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "shouldDisplayNotification", "", "loadImage", "stringUrl", "success", "Lkotlin/Function1;", "Landroid/graphics/Bitmap;", "OmetriaSDK_release"})
public final class NotificationHandler {
    @NotNull
    private final OmetriaThreadPoolExecutor executor;
    @NotNull
    private final OmetriaPushNotification ometriaPushNotification;

    public NotificationHandler(@NotNull Context context, int notificationIcon, @Nullable Integer notificationColor, @NotNull String notificationChannelName, @NotNull OmetriaThreadPoolExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationChannelName, (String)"notificationChannelName");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.ometriaPushNotification = new OmetriaPushNotification(context, notificationIcon, notificationColor, notificationChannelName);
    }

    public final void handleNotification(@NotNull RemoteMessage remoteMessage, boolean shouldDisplayNotification) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        OmetriaNotificationBody ometriaNotificationBody = DeserializationExtensionsKt.toOmetriaNotificationBody(remoteMessage);
        if (ometriaNotificationBody == null) {
            return;
        }
        OmetriaNotificationBody ometriaNotificationBody2 = ometriaNotificationBody;
        Map<String, Object> map = ometriaNotificationBody2.getContext();
        if (map != null) {
            Map<String, Object> it = map;
            boolean bl = false;
            Ometria.Companion.instance().trackNotificationReceivedEvent$OmetriaSDK_release(it);
        }
        if (!shouldDisplayNotification) {
            return;
        }
        String title = (String)remoteMessage.getData().get("title");
        String body = (String)remoteMessage.getData().get("body");
        if (ometriaNotificationBody2.getImageUrl() != null) {
            this.loadImage(ometriaNotificationBody2.getImageUrl(), (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, title, body, ometriaNotificationBody2, remoteMessage){
                final /* synthetic */ NotificationHandler this$0;
                final /* synthetic */ String $title;
                final /* synthetic */ String $body;
                final /* synthetic */ OmetriaNotificationBody $ometriaNotificationBody;
                final /* synthetic */ RemoteMessage $remoteMessage;
                {
                    this.this$0 = $receiver;
                    this.$title = $title;
                    this.$body = $body;
                    this.$ometriaNotificationBody = $ometriaNotificationBody;
                    this.$remoteMessage = $remoteMessage;
                    super(1);
                }

                public final void invoke(@Nullable Bitmap it) {
                    NotificationHandler.access$getOmetriaPushNotification$p(this.this$0).createPushNotification(this.$title, this.$body, it, this.$ometriaNotificationBody, this.$remoteMessage.getCollapseKey());
                }
            }));
        } else {
            OmetriaPushNotification.createPushNotification$default(this.ometriaPushNotification, title, body, null, ometriaNotificationBody2, remoteMessage.getCollapseKey(), 4, null);
        }
    }

    public static /* synthetic */ void handleNotification$default(NotificationHandler notificationHandler, RemoteMessage remoteMessage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        notificationHandler.handleNotification(remoteMessage, bl);
    }

    private final void loadImage(String stringUrl, Function1<? super Bitmap, Unit> success) {
        this.executor.execute(() -> NotificationHandler.loadImage$lambda$1(stringUrl, success));
    }

    private static final void loadImage$lambda$1(String $stringUrl, Function1 $success) {
        Intrinsics.checkNotNullParameter((Object)$success, (String)"$success");
        URL url = new URL($stringUrl);
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)url.openConnection().getInputStream());
        }
        catch (IOException e) {
            Logger.INSTANCE.e("PushNotifications", e.getMessage(), e);
            $success.invoke(null);
        }
        $success.invoke((Object)bitmap);
    }

    public static final /* synthetic */ OmetriaPushNotification access$getOmetriaPushNotification$p(NotificationHandler $this) {
        return $this.ometriaPushNotification;
    }
}

