/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke;

import com.oneeyedmen.okeydoke.Checker;
import com.oneeyedmen.okeydoke.Formatter;
import com.oneeyedmen.okeydoke.Resource;
import com.oneeyedmen.okeydoke.RuntimeIOException;
import com.oneeyedmen.okeydoke.Serializer;
import com.oneeyedmen.okeydoke.SourceOfApproval;
import com.oneeyedmen.okeydoke.internal.IO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class BaseApprover<ApprovedT, ComparedT> {
    private final String testName;
    private final SourceOfApproval sourceOfApproval;
    private final Formatter<ApprovedT, ComparedT> formatter;
    private final Serializer<ComparedT> serializer;
    private final Checker<ComparedT> checker;
    private Resource actual;
    private boolean done;

    protected BaseApprover(String testName, SourceOfApproval sourceOfApproval, Formatter<ApprovedT, ComparedT> formatter, Serializer<ComparedT> serializer, Checker<ComparedT> checker) {
        this.testName = testName;
        this.sourceOfApproval = sourceOfApproval;
        this.formatter = formatter;
        this.serializer = serializer;
        this.checker = checker;
    }

    public PrintStream printStream() {
        try {
            return new PrintStream(this.actual().outputStream());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public OutputStream outputStream() throws IOException {
        return this.actual().outputStream();
    }

    public void writeFormatted(ApprovedT object) {
        this.writeFormatted(object, this.formatter);
    }

    public <AT extends ApprovedT> void writeFormatted(AT object, Formatter<AT, ComparedT> aFormatter) {
        try {
            this.serializer.writeTo(aFormatter.formatted(object), this.actual().outputStream());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void assertApproved(ApprovedT actual) {
        this.assertApproved(actual, this.formatter);
    }

    public <AT extends ApprovedT> void assertApproved(AT actual, Formatter<AT, ComparedT> aFormatter) {
        this.writeFormatted(actual, aFormatter);
        this.assertSatisfied();
    }

    public void assertSatisfied() {
        try {
            this.actual().outputStream().close();
            this.sourceOfApproval.checkActualAgainstApproved(this.testName(), this.serializer, this.checker);
            this.actual().remove();
        }
        catch (AssertionError e) {
            this.sourceOfApproval.reportFailure(this.testName(), e);
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        finally {
            this.actual = null;
            this.done = true;
        }
    }

    public void makeApproved(ApprovedT approved) throws IOException {
        OutputStream output = this.sourceOfApproval.approvedFor(this.testName()).outputStream();
        try {
            this.serializer.writeTo(this.formatter.formatted(approved), output);
        }
        finally {
            IO.closeQuietly(output);
        }
    }

    public boolean satisfactionChecked() {
        return this.done;
    }

    public Formatter<ApprovedT, ComparedT> formatter() {
        return this.formatter;
    }

    private Resource actual() throws IOException {
        if (this.actual == null) {
            this.actual = this.sourceOfApproval.actualFor(this.testName());
        }
        return this.actual;
    }

    protected String testName() {
        return this.testName;
    }

    public void removeApproved() throws IOException {
        this.sourceOfApproval.approvedFor(this.testName()).remove();
    }
}

